/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import com.yahoo.search.dispatch.searchcluster.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Group {
    private static final Logger log = Logger.getLogger(Group.class.getName());
    private static final double maxContentSkew = 0.1;
    private static final int minDocsPerNodeToRequireLowSkew = 100;
    private final int id;
    private final List<Node> nodes;
    private volatile boolean hasSufficientCoverage = true;
    private volatile boolean hasFullCoverage = true;
    private volatile long activeDocuments = 0L;
    private volatile long targetActiveDocuments = 0L;
    private volatile boolean isBlockingWrites = false;
    private volatile boolean isBalanced = true;

    public Group(int id, List<Node> nodes) {
        this.id = id;
        this.nodes = List.copyOf(nodes);
        int idx = 0;
        for (Node node : nodes) {
            node.setPathIndex(idx);
            ++idx;
        }
    }

    public int id() {
        return this.id;
    }

    public List<Node> nodes() {
        return this.nodes;
    }

    public boolean hasSufficientCoverage() {
        return this.hasSufficientCoverage;
    }

    void setHasSufficientCoverage(boolean sufficientCoverage) {
        this.hasSufficientCoverage = sufficientCoverage;
    }

    public int workingNodes() {
        return (int)this.nodes.stream().filter(node -> node.isWorking() == Boolean.TRUE).count();
    }

    public void aggregateNodeValues() {
        long activeDocs;
        ArrayList<Node> workingNodes = new ArrayList<Node>(this.nodes);
        workingNodes.removeIf(node -> node.isWorking() != Boolean.TRUE);
        this.activeDocuments = activeDocs = workingNodes.stream().mapToLong(Node::getActiveDocuments).sum();
        this.targetActiveDocuments = workingNodes.stream().mapToLong(Node::getTargetActiveDocuments).sum();
        this.isBlockingWrites = this.nodes.stream().anyMatch(Node::isBlockingWrites);
        int numWorkingNodes = workingNodes.size();
        if (numWorkingNodes > 0) {
            boolean balanced;
            long average = activeDocs / (long)numWorkingNodes;
            long skew = workingNodes.stream().mapToLong(node -> Math.abs(node.getActiveDocuments() - average)).sum();
            boolean bl = balanced = (double)skew <= (double)activeDocs * 0.1;
            if (balanced != this.isBalanced) {
                if (!this.isSparse()) {
                    log.info("Content in " + this + ", with " + numWorkingNodes + "/" + this.nodes.size() + " working nodes, is " + (balanced ? "" : "not ") + "well balanced. Current deviation: " + skew * 100L / activeDocs + "%. Active documents: " + activeDocs + ", skew: " + skew + ", average: " + average + (balanced ? "" : ". Top-k summary fetch optimization is deactivated."));
                }
                this.isBalanced = balanced;
            }
        } else {
            this.isBalanced = true;
        }
    }

    long activeDocuments() {
        return this.activeDocuments;
    }

    long targetActiveDocuments() {
        return this.targetActiveDocuments;
    }

    public boolean isBlockingWrites() {
        return this.isBlockingWrites;
    }

    public boolean isBalanced() {
        return this.isBalanced;
    }

    public boolean isSparse() {
        if (this.nodes.isEmpty()) {
            return false;
        }
        return this.activeDocuments() / (long)this.nodes.size() < 100L;
    }

    public boolean fullCoverageStatusChanged(boolean hasFullCoverageNow) {
        boolean previousState = this.hasFullCoverage;
        this.hasFullCoverage = hasFullCoverageNow;
        return previousState != hasFullCoverageNow;
    }

    public String toString() {
        return "group " + this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Group)) {
            return false;
        }
        return ((Group)other).id == this.id;
    }
}

