/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class Node {
    private final String clusterName;
    private final int key;
    private final String hostname;
    private final int group;
    private int pathIndex;
    private final AtomicLong pingSequence = new AtomicLong(0L);
    private final AtomicLong lastPong = new AtomicLong(0L);
    private volatile long activeDocuments = 0L;
    private volatile long targetActiveDocuments = 0L;
    private volatile boolean statusIsKnown = false;
    private volatile boolean working = true;
    private volatile boolean isBlockingWrites = false;

    public Node(String clusterName, int key, String hostname, int group) {
        this.clusterName = clusterName;
        this.key = key;
        this.hostname = hostname;
        this.group = group;
    }

    public long createPingSequenceId() {
        return this.pingSequence.incrementAndGet();
    }

    public boolean isLastReceivedPong(long pingId) {
        long last = this.lastPong.get();
        while (pingId > last && !this.lastPong.compareAndSet(last, pingId)) {
            last = this.lastPong.get();
        }
        return last < pingId;
    }

    public long getLastReceivedPongId() {
        return this.lastPong.get();
    }

    public int key() {
        return this.key;
    }

    public int pathIndex() {
        return this.pathIndex;
    }

    void setPathIndex(int index) {
        this.pathIndex = index;
    }

    public String hostname() {
        return this.hostname;
    }

    public int group() {
        return this.group;
    }

    public void setWorking(boolean working) {
        this.statusIsKnown = true;
        this.working = working;
        if (!working) {
            this.activeDocuments = 0L;
            this.targetActiveDocuments = 0L;
        }
    }

    public Boolean isWorking() {
        return this.statusIsKnown ? Boolean.valueOf(this.working) : null;
    }

    public void setActiveDocuments(long documents) {
        this.activeDocuments = documents;
    }

    public void setTargetActiveDocuments(long documents) {
        this.targetActiveDocuments = documents;
    }

    long getActiveDocuments() {
        return this.activeDocuments;
    }

    long getTargetActiveDocuments() {
        return this.targetActiveDocuments;
    }

    public void setBlockingWrites(boolean isBlockingWrites) {
        this.isBlockingWrites = isBlockingWrites;
    }

    boolean isBlockingWrites() {
        return this.isBlockingWrites;
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.key, this.group);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!Objects.equals(this.hostname, other.hostname)) {
            return false;
        }
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        return Objects.equals(this.group, other.group);
    }

    public String toString() {
        return "search node in cluster = " + this.clusterName + " key = " + this.key + " hostname = " + this.hostname + " path = " + this.pathIndex + " in group " + this.group + " statusIsKnown = " + this.statusIsKnown + " working = " + this.working + " activeDocs = " + this.getActiveDocuments() + " targetActiveDocs = " + this.getTargetActiveDocuments();
    }
}

