/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.compiled;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.query.profile.QueryProfileProperties;
import com.yahoo.search.query.profile.SubstituteString;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.compiled.DimensionalMap;
import com.yahoo.search.query.profile.compiled.DimensionalValue;
import com.yahoo.search.query.profile.compiled.ValueWithSource;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompiledQueryProfile
extends AbstractComponent
implements Cloneable {
    private static final Pattern namePattern = Pattern.compile("[$a-zA-Z_/][-$a-zA-Z0-9_/()]*");
    private final CompiledQueryProfileRegistry registry;
    private final QueryProfileType type;
    private final DimensionalMap<ValueWithSource> entries;
    private final DimensionalMap<QueryProfileType> types;
    private final DimensionalMap<Object> references;
    private final DimensionalMap<Object> unoverridables;

    public CompiledQueryProfile(ComponentId id, QueryProfileType type, DimensionalMap<ValueWithSource> entries, DimensionalMap<QueryProfileType> types, DimensionalMap<Object> references, DimensionalMap<Object> unoverridables, CompiledQueryProfileRegistry registry) {
        super(id);
        this.registry = registry;
        if (type != null) {
            type.freeze();
        }
        this.type = type;
        this.entries = entries;
        this.types = types;
        this.references = references;
        this.unoverridables = unoverridables;
        if (!id.isAnonymous()) {
            CompiledQueryProfile.validateName(id.getName());
        }
    }

    public CompiledQueryProfileRegistry getRegistry() {
        return this.registry;
    }

    public QueryProfileType getType() {
        return this.type;
    }

    public final boolean isOverridable(CompoundName name, Map<String, String> context) {
        return this.unoverridables.get(name, context) == null;
    }

    public final QueryProfileType getType(CompoundName name, Map<String, String> context) {
        return this.types.get(name, context);
    }

    public DimensionalMap<QueryProfileType> getTypes() {
        return this.types;
    }

    public DimensionalMap<Object> getReferences() {
        return this.references;
    }

    public final Map<String, Object> listValues(CompoundName prefix) {
        return this.listValues(prefix, Collections.emptyMap());
    }

    public final Map<String, Object> listValues(String prefix) {
        return this.listValues(new CompoundName(prefix));
    }

    public final Map<String, Object> listValues(String prefix, Map<String, String> context) {
        return this.listValues(new CompoundName(prefix), context);
    }

    public final Map<String, Object> listValues(CompoundName prefix, Map<String, String> context) {
        return this.listValues(prefix, context, null);
    }

    public Map<String, Object> listValues(CompoundName prefix, Map<String, String> context, Properties substitution) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<CompoundName, DimensionalValue<ValueWithSource>> entry : this.entries.entrySet()) {
            Object value;
            ValueWithSource valueWithSource;
            if (!entry.getKey().hasPrefix(prefix) || (valueWithSource = entry.getValue().get(context)) == null || (value = valueWithSource.value()) == null) continue;
            value = this.substitute(value, context, substitution);
            CompoundName suffixName = entry.getKey().rest(prefix.size());
            values.put(suffixName.toString(), value);
        }
        return values;
    }

    public Map<String, ValueWithSource> listValuesWithSources(CompoundName prefix, Map<String, String> context, Properties substitution) {
        HashMap<String, ValueWithSource> values = new HashMap<String, ValueWithSource>();
        for (Map.Entry<CompoundName, DimensionalValue<ValueWithSource>> entry : this.entries.entrySet()) {
            ValueWithSource valueWithSource;
            if (entry.getKey().size() <= prefix.size() || !entry.getKey().hasPrefix(prefix) || (valueWithSource = entry.getValue().get(context)) == null || valueWithSource.value() == null) continue;
            valueWithSource = valueWithSource.withValue(this.substitute(valueWithSource.value(), context, substitution));
            CompoundName suffixName = entry.getKey().rest(prefix.size());
            values.put(suffixName.toString(), valueWithSource);
        }
        return values;
    }

    public final Object get(String name) {
        return this.get(name, Map.of());
    }

    public final Object get(String name, Map<String, String> context) {
        return this.get(name, context, (Properties)new QueryProfileProperties(this));
    }

    public final Object get(String name, Map<String, String> context, Properties substitution) {
        return this.get(new CompoundName(name), context, substitution);
    }

    public final Object get(CompoundName name, Map<String, String> context, Properties substitution) {
        ValueWithSource value = this.entries.get(name, context);
        if (value == null) {
            return null;
        }
        return this.substitute(value.value(), context, substitution);
    }

    public final DimensionalMap<ValueWithSource> getEntries() {
        return this.entries;
    }

    private Object substitute(Object value, Map<String, String> context, Properties substitution) {
        if (value == null) {
            return value;
        }
        if (substitution == null) {
            return value;
        }
        if (!(value instanceof SubstituteString)) {
            return value;
        }
        return ((SubstituteString)value).substitute(context, substitution);
    }

    private static void validateName(String name) {
        Matcher nameMatcher = namePattern.matcher(name);
        if (!nameMatcher.matches()) {
            throw new IllegalArgumentException("Illegal name '" + name + "'");
        }
    }

    public CompiledQueryProfile clone() {
        return this;
    }

    public String toString() {
        return "query profile '" + this.getId() + "'" + (String)(this.type != null ? " of type '" + this.type.getId() + "'" : "");
    }
}

