/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.language.Language;
import com.yahoo.language.process.Embedder;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import java.util.Map;

public class ConversionContext {
    private final String destination;
    private final CompiledQueryProfileRegistry registry;
    private final Map<String, Embedder> embedders;
    private final Language language;

    public ConversionContext(String destination, CompiledQueryProfileRegistry registry, Embedder embedder, Map<String, String> context) {
        this(destination, registry, Map.of("default", embedder), context);
    }

    public ConversionContext(String destination, CompiledQueryProfileRegistry registry, Map<String, Embedder> embedders, Map<String, String> context) {
        this.destination = destination;
        this.registry = registry;
        this.embedders = embedders;
        this.language = context.containsKey("language") ? Language.fromLanguageTag((String)context.get("language")) : Language.UNKNOWN;
    }

    public String destination() {
        return this.destination;
    }

    CompiledQueryProfileRegistry registry() {
        return this.registry;
    }

    Map<String, Embedder> embedders() {
        return this.embedders;
    }

    Language language() {
        return this.language;
    }

    public static ConversionContext empty() {
        return new ConversionContext(null, null, Embedder.throwsOnUse.asMap(), Map.of());
    }
}

