/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.properties;

import com.yahoo.api.annotations.Beta;
import com.yahoo.language.process.Embedder;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.ranking.RankFeatures;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.schema.internal.TensorConverter;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Map;

@Beta
public class RankProfileInputProperties
extends Properties {
    private final SchemaInfo schemaInfo;
    private final Query query;
    private final TensorConverter tensorConverter;
    private SchemaInfo.Session session = null;

    public RankProfileInputProperties(SchemaInfo schemaInfo, Query query, Map<String, Embedder> embedders) {
        this.schemaInfo = schemaInfo;
        this.query = query;
        this.tensorConverter = new TensorConverter(embedders);
    }

    public void set(CompoundName name, Object value, Map<String, String> context) {
        TensorType expectedType;
        if (RankFeatures.isFeatureName(name.toString()) && (expectedType = this.typeOf(name)) != null) {
            try {
                value = this.tensorConverter.convertTo(expectedType, name.last(), value, this.query.getModel().getLanguage());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalInputException("Could not set '" + name + "' to '" + value + "'", (Throwable)e);
            }
        }
        super.set(name, value, context);
    }

    @Override
    public void requireSettable(CompoundName name, Object value, Map<String, String> context) {
        TensorType expectedType;
        if (RankFeatures.isFeatureName(name.toString()) && (expectedType = this.typeOf(name)) != null) {
            this.verifyType(name, value, expectedType);
        }
        super.requireSettable(name, value, context);
    }

    private TensorType typeOf(CompoundName name) {
        if (this.session == null) {
            this.session = this.schemaInfo.newSession(this.query);
        }
        return this.session.rankProfileInput(name.last(), this.query.getRanking().getProfile());
    }

    private void verifyType(CompoundName name, Object value, TensorType expectedType) {
        if (value instanceof Tensor) {
            TensorType valueType = ((Tensor)value).type();
            if (!valueType.isAssignableTo(expectedType)) {
                this.throwIllegalInput(name, value, expectedType);
            }
        } else if (expectedType.rank() > 0) {
            this.throwIllegalInput(name, value, expectedType);
        }
    }

    private void throwIllegalInput(CompoundName name, Object value, TensorType expectedType) {
        throw new IllegalInputException("Could not set '" + name + "' to '" + value + "': This input is declared in rank profile '" + this.query.getRanking().getProfile() + "' as " + expectedType);
    }
}

