/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import com.yahoo.search.ranking.Evaluator;
import com.yahoo.search.result.FeatureData;
import com.yahoo.search.result.Hit;
import com.yahoo.tensor.Tensor;
import java.util.function.Supplier;
import java.util.logging.Logger;

class HitRescorer {
    private static final Logger logger = Logger.getLogger(HitRescorer.class.getName());
    private final Supplier<Evaluator> evaluatorSource;
    private static final String RE_PREFIX = "rankingExpression(";
    private static final String RE_SUFFIX = ")";
    private static final int RE_PRE_LEN = "rankingExpression(".length();
    private static final int RE_SUF_LEN = ")".length();

    public HitRescorer(Supplier<Evaluator> evaluatorSource) {
        this.evaluatorSource = evaluatorSource;
    }

    boolean rescoreHit(Hit hit) {
        Object features = hit.getField("matchfeatures");
        if (features instanceof FeatureData) {
            FeatureData matchFeatures = (FeatureData)features;
            Evaluator scorer = this.evaluatorSource.get();
            for (String argName : scorer.needInputs()) {
                Tensor asTensor = matchFeatures.getTensor(argName);
                if (asTensor == null) {
                    asTensor = matchFeatures.getTensor(HitRescorer.alternate(argName));
                }
                if (asTensor != null) {
                    scorer.bind(argName, asTensor);
                    continue;
                }
                logger.warning("Missing match-feature for Evaluator argument: " + argName);
                return false;
            }
            double newScore = scorer.evaluateScore();
            hit.setRelevance(newScore);
            return true;
        }
        logger.warning("Hit without match-features: " + hit);
        return false;
    }

    static String alternate(String argName) {
        if (argName.startsWith(RE_PREFIX) && argName.endsWith(RE_SUFFIX)) {
            return argName.substring(RE_PRE_LEN, argName.length() - RE_SUF_LEN);
        }
        return argName;
    }
}

