/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import com.yahoo.search.Result;
import com.yahoo.search.ranking.HitRescorer;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Logger;

class ResultReranker {
    private static final Logger logger = Logger.getLogger(ResultReranker.class.getName());

    ResultReranker() {
    }

    static void rerankHits(Result result, HitRescorer hitRescorer, int rerankCount) {
        ArrayList<Hit> hitsToRescore = new ArrayList<Hit>();
        Iterator<Hit> iterator = result.hits().deepIterator();
        while (iterator.hasNext()) {
            Hit hit = iterator.next();
            if (hit.isMeta() || hit instanceof HitGroup) continue;
            hitsToRescore.add(hit);
        }
        hitsToRescore.sort(Comparator.naturalOrder());
        Ranges ranges = new Ranges();
        Iterator iterator2 = hitsToRescore.iterator();
        while (rerankCount > 0 && iterator2.hasNext()) {
            Hit hit = (Hit)iterator2.next();
            double oldScore = hit.getRelevance().getScore();
            boolean didRerank = hitRescorer.rescoreHit(hit);
            if (!didRerank) continue;
            ranges.withInitialScore(oldScore);
            ranges.withFinalScore(hit.getRelevance().getScore());
            --rerankCount;
            iterator2.remove();
        }
        if (ranges.rescaleNeeded()) {
            double scale = ranges.scale();
            double bias = ranges.bias();
            for (Hit hit : hitsToRescore) {
                double oldScore = hit.getRelevance().getScore();
                hit.setRelevance(oldScore * scale + bias);
            }
        }
        result.hits().sort();
    }

    static class Ranges {
        private double initialScores_high = -1.7976931348623157E308;
        private double initialScores_low = Double.MAX_VALUE;
        private double finalScores_high = -1.7976931348623157E308;
        private double finalScores_low = Double.MAX_VALUE;

        Ranges() {
        }

        boolean rescaleNeeded() {
            return this.initialScores_low > this.finalScores_low && this.initialScores_high >= this.initialScores_low && this.finalScores_high >= this.finalScores_low;
        }

        void withInitialScore(double score) {
            if (score < this.initialScores_low) {
                this.initialScores_low = score;
            }
            if (score > this.initialScores_high) {
                this.initialScores_high = score;
            }
        }

        void withFinalScore(double score) {
            if (score < this.finalScores_low) {
                this.finalScores_low = score;
            }
            if (score > this.finalScores_high) {
                this.finalScores_high = score;
            }
        }

        private double initialRange() {
            double r = this.initialScores_high - this.initialScores_low;
            if (r < 1.0) {
                r = 1.0;
            }
            return r;
        }

        private double finalRange() {
            double r = this.finalScores_high - this.finalScores_low;
            if (r < 1.0) {
                r = 1.0;
            }
            return r;
        }

        double scale() {
            return this.finalRange() / this.initialRange();
        }

        double bias() {
            return this.finalScores_low - this.initialScores_low * this.scale();
        }
    }
}

