/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema;

import com.yahoo.api.annotations.Beta;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.search.Query;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.search.schema.Cluster;
import com.yahoo.search.schema.FieldInfo;
import com.yahoo.search.schema.RankProfile;
import com.yahoo.search.schema.Schema;
import com.yahoo.search.schema.SchemaInfoConfigurer;
import com.yahoo.tensor.TensorType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Beta
public class SchemaInfo {
    private static final SchemaInfo empty = new SchemaInfo(List.of(), List.of());
    private final Map<String, Schema> schemas;
    private final Map<String, Cluster> clusters;

    @Inject
    public SchemaInfo(SchemaInfoConfig schemaInfoConfig, QrSearchersConfig qrSearchersConfig) {
        this(SchemaInfoConfigurer.toSchemas(schemaInfoConfig), SchemaInfoConfigurer.toClusters(qrSearchersConfig));
    }

    public SchemaInfo(List<Schema> schemas, List<Cluster> clusters) {
        LinkedHashMap schemaMap = new LinkedHashMap();
        schemas.forEach(schema -> schemaMap.put(schema.name(), schema));
        this.schemas = Collections.unmodifiableMap(schemaMap);
        LinkedHashMap clusterMap = new LinkedHashMap();
        clusters.forEach(cluster -> clusterMap.put(cluster.name(), cluster));
        this.clusters = Collections.unmodifiableMap(clusterMap);
    }

    public Map<String, Schema> schemas() {
        return this.schemas;
    }

    public Map<String, Cluster> clusters() {
        return this.clusters;
    }

    public Session newSession(Query query) {
        return new Session(query.getModel().getSources(), query.getModel().getRestrict(), this.clusters, this.schemas);
    }

    public static SchemaInfo empty() {
        return empty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaInfo)) {
            return false;
        }
        SchemaInfo other = (SchemaInfo)o;
        if (!other.schemas.equals(this.schemas)) {
            return false;
        }
        return other.clusters.equals(this.clusters);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.clusters);
    }

    public static class Session {
        private final boolean isStreaming;
        private final Collection<Schema> schemas;

        private Session(Set<String> sources, Set<String> restrict, Map<String, Cluster> clusters, Map<String, Schema> candidates) {
            this.isStreaming = Session.resolveStreaming(sources, clusters);
            this.schemas = Session.resolveSchemas(sources, restrict, clusters, candidates.values());
        }

        public boolean isStreaming() {
            return this.isStreaming;
        }

        public Optional<FieldInfo> fieldInfo(String fieldName) {
            for (Schema schema : this.schemas) {
                Optional<FieldInfo> field = schema.fieldInfo(fieldName);
                if (!field.isPresent()) continue;
                return field;
            }
            return Optional.empty();
        }

        private static boolean resolveStreaming(Set<String> sources, Map<String, Cluster> clusters) {
            if (sources.isEmpty()) {
                return clusters.values().stream().allMatch(Cluster::isStreaming);
            }
            List<Cluster> matchedClusters = sources.stream().map(source -> Session.clusterOfSource(source, clusters)).filter(Objects::nonNull).toList();
            if (matchedClusters.isEmpty()) {
                return false;
            }
            return matchedClusters.stream().allMatch(Cluster::isStreaming);
        }

        private static Cluster clusterOfSource(String source, Map<String, Cluster> clusters) {
            Cluster cluster = clusters.get(source);
            if (cluster != null) {
                return cluster;
            }
            for (Cluster c : clusters.values()) {
                if (!c.schemas().contains(source)) continue;
                return c;
            }
            return null;
        }

        private static Collection<Schema> resolveSchemas(Set<String> sources, Set<String> restrict, Map<String, Cluster> clusters, Collection<Schema> candidates) {
            if (sources.isEmpty()) {
                return restrict.isEmpty() ? candidates : Session.keep(restrict, candidates);
            }
            HashSet<String> schemaNames = new HashSet<String>();
            for (String source : sources) {
                if (clusters.containsKey(source)) {
                    schemaNames.addAll(clusters.get(source).schemas());
                    continue;
                }
                schemaNames.add(source);
            }
            candidates = Session.keep(schemaNames, candidates);
            return restrict.isEmpty() ? candidates : Session.keep(restrict, candidates);
        }

        private static List<Schema> keep(Set<String> names, Collection<Schema> schemas) {
            return schemas.stream().filter(schema -> names.contains(schema.name())).toList();
        }

        public TensorType rankProfileInput(String rankFeature, String rankProfile) {
            if (this.schemas.isEmpty()) {
                return null;
            }
            List<RankProfile> profiles = this.profilesNamed(rankProfile);
            if (profiles.isEmpty()) {
                throw new IllegalArgumentException("No profile named '" + rankProfile + "' exists in schemas [" + this.schemas.stream().map(Schema::name).collect(Collectors.joining(", ")) + "]");
            }
            TensorType foundType = null;
            RankProfile declaringProfile = null;
            for (RankProfile profile : profiles) {
                TensorType newlyFoundType = profile.inputs().get(rankFeature);
                if (newlyFoundType == null) continue;
                if (foundType != null && !newlyFoundType.equals((Object)foundType)) {
                    throw new IllegalArgumentException("Conflicting input type declarations for '" + rankFeature + "': Declared as " + foundType + " in " + declaringProfile + ", and as " + newlyFoundType + " in " + profile);
                }
                foundType = newlyFoundType;
                declaringProfile = profile;
            }
            return foundType;
        }

        private List<RankProfile> profilesNamed(String name) {
            return this.schemas.stream().filter(schema -> schema.rankProfiles().containsKey(name)).map(schema -> schema.rankProfiles().get(name)).toList();
        }
    }
}

