/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.FuzzyItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.chain.Before;
import java.util.Optional;

@Before(value={"GroupingExecutor"})
public class ValidateFuzzySearcher
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        Optional<ErrorMessage> e = this.validate(query, execution.context().getIndexFacts().newSession(query));
        return e.isEmpty() ? execution.search(query) : new Result(query, e.get());
    }

    private Optional<ErrorMessage> validate(Query query, IndexFacts.Session indexFacts) {
        FuzzyVisitor visitor = new FuzzyVisitor(indexFacts);
        ToolBox.visit(visitor, query.getModel().getQueryTree().getRoot());
        return visitor.errorMessage;
    }

    private static class FuzzyVisitor
    extends ToolBox.QueryVisitor {
        public Optional<ErrorMessage> errorMessage = Optional.empty();
        private final IndexFacts.Session indexFacts;

        public FuzzyVisitor(IndexFacts.Session indexFacts) {
            this.indexFacts = indexFacts;
        }

        @Override
        public boolean visit(Item item) {
            String error;
            if (item instanceof FuzzyItem && (error = this.validate((FuzzyItem)item)) != null) {
                this.errorMessage = Optional.of(ErrorMessage.createIllegalQuery(error));
            }
            return true;
        }

        private String validate(FuzzyItem item) {
            String indexName = item.getIndexName();
            Index index = this.getIndexFromUnionOfDocumentTypes(indexName);
            if (!index.isAttribute() || !index.isString()) {
                return item + " field is not a string attribute";
            }
            if (item.getPrefixLength() < 0) {
                return item + " has invalid prefixLength " + item.getPrefixLength() + ": Must be >= 0";
            }
            if (item.getMaxEditDistance() < 0) {
                return item + " has invalid maxEditDistance " + item.getMaxEditDistance() + ": Must be >= 0";
            }
            if (item.stringValue().isEmpty()) {
                return item + " fuzzy query must be non-empty";
            }
            return null;
        }

        private Index getIndexFromUnionOfDocumentTypes(String indexName) {
            return this.indexFacts.getIndex(indexName);
        }

        @Override
        public void onExit() {
        }
    }
}

