/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.fastsearch.VespaBackend;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.InvokerFactory;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.rpc.CompressPayload;
import com.yahoo.search.dispatch.rpc.CompressService;
import com.yahoo.search.dispatch.rpc.RpcConnectionPool;
import com.yahoo.search.dispatch.rpc.RpcProtobufFillInvoker;
import com.yahoo.search.dispatch.rpc.RpcSearchInvoker;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchGroups;
import com.yahoo.vespa.config.search.DispatchConfig;
import java.util.Optional;

public class RpcInvokerFactory
extends InvokerFactory {
    private final RpcConnectionPool rpcResourcePool;
    private final CompressPayload compressor;
    private final RpcProtobufFillInvoker.DecodePolicy decodeType;
    private final QrSearchersConfig qrSearchersConfig;

    private static RpcProtobufFillInvoker.DecodePolicy convert(DispatchConfig.SummaryDecodePolicy.Enum decoding) {
        return switch (decoding) {
            default -> throw new IncompatibleClassChangeError();
            case DispatchConfig.SummaryDecodePolicy.Enum.EAGER -> RpcProtobufFillInvoker.DecodePolicy.EAGER;
            case DispatchConfig.SummaryDecodePolicy.Enum.ONDEMAND -> RpcProtobufFillInvoker.DecodePolicy.ONDEMAND;
        };
    }

    public RpcInvokerFactory(RpcConnectionPool rpcResourcePool, SearchGroups cluster, DispatchConfig dispatchConfig, QrSearchersConfig qrSearchersConfig) {
        super(cluster, dispatchConfig);
        this.rpcResourcePool = rpcResourcePool;
        this.compressor = new CompressService();
        this.decodeType = RpcInvokerFactory.convert(dispatchConfig.summaryDecodePolicy());
        this.qrSearchersConfig = qrSearchersConfig;
    }

    @Override
    protected Optional<SearchInvoker> createNodeSearchInvoker(VespaBackend searcher, Query query, int maxHits, Node node) {
        return Optional.of(new RpcSearchInvoker(searcher, this.compressor, node, this.rpcResourcePool, maxHits, this.qrSearchersConfig));
    }

    @Override
    public FillInvoker createFillInvoker(VespaBackend searcher, Result result) {
        Query query = result.getQuery();
        boolean summaryNeedsQuery = searcher.summaryNeedsQuery(query);
        return new RpcProtobufFillInvoker(this.rpcResourcePool, this.compressor, searcher.getDocumentDatabase(query), searcher.getServerId(), this.decodeType, summaryNeedsQuery);
    }
}

