/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.api.annotations.Beta;
import com.yahoo.search.grouping.request.FilterExpression;
import com.yahoo.search.grouping.request.GroupingExpression;
import java.util.Locale;

@Beta
public class RangePredicate
extends FilterExpression {
    private final Number lower;
    private final Number upper;
    private final boolean lowerInclusive;
    private final boolean upperInclusive;
    private final GroupingExpression expression;

    public RangePredicate(Number lower, Number upper, GroupingExpression expression) {
        this(lower, upper, expression, true, false);
    }

    public RangePredicate(Number lower, Number upper, GroupingExpression expression, boolean lowerInclusive, boolean upperInclusive) {
        this.lower = lower;
        this.upper = upper;
        this.lowerInclusive = lowerInclusive;
        this.upperInclusive = upperInclusive;
        this.expression = expression;
    }

    public Number getLower() {
        return this.lower;
    }

    public Number getUpper() {
        return this.upper;
    }

    public boolean getLowerInclusive() {
        return this.lowerInclusive;
    }

    public boolean getUpperInclusive() {
        return this.upperInclusive;
    }

    public GroupingExpression getExpression() {
        return this.expression;
    }

    @Override
    public String toString() {
        return String.format(Locale.US, "range(%s, %s, %s, %b, %b)", this.lower, this.upper, this.expression, this.lowerInclusive, this.upperInclusive);
    }

    @Override
    public FilterExpression copy() {
        return new RangePredicate(this.lower, this.upper, this.expression.copy(), this.lowerInclusive, this.upperInclusive);
    }
}

