/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.schema.internal;

import com.yahoo.language.Language;
import com.yahoo.language.process.Embedder;
import com.yahoo.processing.request.Properties;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TensorConverter {
    private static final Pattern embedderArgumentAndQuotedTextRegexp = Pattern.compile("^([A-Za-z0-9_@\\-.]+),\\s*([\"'].*[\"'])");
    private static final Pattern embedderArgumentAndReferenceRegexp = Pattern.compile("^([A-Za-z0-9_@\\-.]+),\\s*(@.*)");
    private final Map<String, Embedder> embedders;

    public TensorConverter(Map<String, Embedder> embedders) {
        this.embedders = embedders;
    }

    public Tensor convertTo(TensorType type, String key, Object value, Language language, Map<String, String> contextValues, Properties properties) {
        Embedder.Context context = (Embedder.Context)new Embedder.Context(key).setLanguage(language);
        Tensor tensor = this.toTensor(type, value, context, contextValues, properties);
        if (tensor == null) {
            return null;
        }
        if (!tensor.type().isAssignableTo(type)) {
            throw new IllegalArgumentException("Require a tensor of type " + String.valueOf(type));
        }
        return tensor;
    }

    private Tensor toTensor(TensorType type, Object value, Embedder.Context context, Map<String, String> contextValues, Properties properties) {
        if (value instanceof Tensor) {
            return (Tensor)value;
        }
        if (value instanceof String && TensorConverter.isEmbed((String)value)) {
            return this.embed((String)value, type, context, contextValues, properties);
        }
        if (value instanceof String) {
            return Tensor.from((TensorType)type, (String)((String)value));
        }
        return null;
    }

    static boolean isEmbed(String value) {
        return value.startsWith("embed(");
    }

    private Tensor embed(String s, TensorType type, Embedder.Context embedderContext, Map<String, String> contextValues, Properties properties) {
        Embedder embedder;
        String embedderId;
        if (!s.endsWith(")")) {
            throw new IllegalArgumentException("Expected any string enclosed in embed(), but the argument does not end by ')'");
        }
        String argument = s.substring("embed(".length(), s.length() - 1);
        Matcher matcher = embedderArgumentAndQuotedTextRegexp.matcher(argument);
        if (matcher.matches()) {
            embedderId = matcher.group(1);
            embedder = this.requireEmbedder(embedderId);
            argument = matcher.group(2);
        } else {
            matcher = embedderArgumentAndReferenceRegexp.matcher(argument);
            if (matcher.matches()) {
                embedderId = matcher.group(1);
                embedder = this.requireEmbedder(embedderId);
                argument = matcher.group(2);
            } else {
                if (this.embedders.isEmpty()) {
                    throw new IllegalArgumentException("No embedders provided");
                }
                if (this.embedders.size() > 1) {
                    String usage = "Usage: embed(embedder-id, 'text'). " + TensorConverter.embedderIds(this.embedders);
                    if (!argument.contains("\"") && !argument.contains("'")) {
                        throw new IllegalArgumentException("Multiple embedders are provided but the string to embed is not quoted. " + usage);
                    }
                    throw new IllegalArgumentException("Multiple embedders are provided but no embedder id is given. " + usage);
                }
                Map.Entry entry = (Map.Entry)this.embedders.entrySet().stream().findFirst().get();
                embedderId = (String)entry.getKey();
                embedder = (Embedder)entry.getValue();
            }
        }
        return embedder.embed(TensorConverter.resolve(argument, contextValues, properties), embedderContext.copy().setEmbedderId(embedderId), type);
    }

    private Embedder requireEmbedder(String embedderId) {
        if (!this.embedders.containsKey(embedderId)) {
            throw new IllegalArgumentException("Can't find embedder '" + embedderId + "'. " + TensorConverter.embedderIds(this.embedders));
        }
        return this.embedders.get(embedderId);
    }

    private static String resolve(String s, Map<String, String> contextValues, Properties properties) {
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("@")) {
            return TensorConverter.resolveReference(s, contextValues, properties);
        }
        return s;
    }

    private static String resolveReference(String s, Map<String, String> contextValues, Properties properties) {
        String referenceKey = s.substring(1);
        Object referencedValue = properties.get(referenceKey, contextValues);
        if (referencedValue == null) {
            throw new IllegalArgumentException("Could not resolve query parameter reference '" + referenceKey + "' used in an embed() argument");
        }
        return referencedValue.toString();
    }

    private static String embedderIds(Map<String, Embedder> embedders) {
        ArrayList embedderIds = new ArrayList();
        embedders.forEach((key, value) -> embedderIds.add("'" + key + "'"));
        embedderIds.sort(null);
        return "Available embedder ids are " + String.join((CharSequence)", ", embedderIds) + ".";
    }
}

