/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.cluster;

import com.yahoo.collections.TinyIdentitySet;
import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.core.documentapi.VespaDocumentAccess;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.prelude.fastsearch.ClusterParams;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.IndexedBackend;
import com.yahoo.prelude.fastsearch.VespaBackend;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.search.query.ParameterParser;
import com.yahoo.search.ranking.GlobalPhaseRanker;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.schema.Cluster;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.streamingvisitors.StreamingBackend;
import com.yahoo.yolean.Exceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;

@After(value={"*"})
public class ClusterSearcher
extends Searcher {
    private static final long DEFAULT_MAX_QUERY_TIMEOUT = 600000L;
    private static final long DEFAULT_MAX_QUERY_CACHE_TIMEOUT = 10000L;
    private final String searchClusterName;
    private final Map<String, VespaBackend> schema2Searcher;
    private final SchemaInfo schemaInfo;
    private final long maxQueryTimeout;
    private final long maxQueryCacheTimeout;
    private final Executor executor;
    private final GlobalPhaseRanker globalPhaseRanker;

    @Inject
    public ClusterSearcher(ComponentId id, Executor executor, ClusterConfig clusterConfig, DocumentdbInfoConfig documentDbConfig, SchemaInfo schemaInfo, ComponentRegistry<Dispatcher> dispatchers, GlobalPhaseRanker globalPhaseRanker, VipStatus vipStatus, VespaDocumentAccess access) {
        super(id);
        this.executor = executor;
        this.schemaInfo = schemaInfo;
        this.searchClusterName = clusterConfig.clusterName();
        this.globalPhaseRanker = globalPhaseRanker;
        this.schema2Searcher = new LinkedHashMap<String, VespaBackend>();
        this.maxQueryTimeout = ParameterParser.asMilliSeconds(clusterConfig.maxQueryTimeout(), 600000L);
        this.maxQueryCacheTimeout = ParameterParser.asMilliSeconds(clusterConfig.maxQueryCacheTimeout(), 10000L);
        StreamingBackend streaming = null;
        IndexedBackend indexed = null;
        ClusterParams clusterParams = ClusterSearcher.makeClusterParams(this.searchClusterName, documentDbConfig, schemaInfo);
        for (DocumentdbInfoConfig.Documentdb docDb : documentDbConfig.documentdb()) {
            if (docDb.mode() == DocumentdbInfoConfig.Documentdb.Mode.Enum.INDEX) {
                if (indexed == null) {
                    indexed = ClusterSearcher.searchDispatch(clusterParams, this.searchClusterName, dispatchers);
                }
                this.schema2Searcher.put(docDb.name(), indexed);
                continue;
            }
            if (docDb.mode() != DocumentdbInfoConfig.Documentdb.Mode.Enum.STREAMING) continue;
            if (streaming == null) {
                streaming = ClusterSearcher.streamingCluster(clusterParams, clusterConfig, access);
                vipStatus.addToRotation(streaming.getName());
            }
            this.schema2Searcher.put(docDb.name(), streaming);
        }
    }

    private static ClusterParams makeClusterParams(String searchclusterName, DocumentdbInfoConfig documentDbConfig, SchemaInfo schemaInfo) {
        return new ClusterParams(searchclusterName + ".num0", UUID.randomUUID().toString(), null, documentDbConfig, schemaInfo);
    }

    private static IndexedBackend searchDispatch(ClusterParams clusterParams, String searchClusterName, ComponentRegistry<Dispatcher> dispatchers) {
        ComponentId dispatcherComponentId = new ComponentId("dispatcher." + searchClusterName);
        Dispatcher dispatcher = (Dispatcher)((Object)dispatchers.getComponent(dispatcherComponentId));
        if (dispatcher == null) {
            throw new IllegalArgumentException("Configuration error: No dispatcher " + String.valueOf(dispatcherComponentId) + " is configured");
        }
        return new IndexedBackend(clusterParams, dispatcher);
    }

    private static StreamingBackend streamingCluster(ClusterParams clusterParams, ClusterConfig clusterConfig, VespaDocumentAccess access) {
        return new StreamingBackend(clusterParams, clusterConfig.configid(), access, clusterConfig.storageRoute());
    }

    ClusterSearcher(SchemaInfo schemaInfo, Map<String, VespaBackend> schema2Searcher, Executor executor) {
        this.schemaInfo = schemaInfo;
        this.searchClusterName = "testScenario";
        this.maxQueryTimeout = 600000L;
        this.maxQueryCacheTimeout = 10000L;
        this.executor = executor;
        this.globalPhaseRanker = null;
        this.schema2Searcher = schema2Searcher;
    }

    ClusterSearcher(SchemaInfo schemaInfo, Map<String, VespaBackend> schema2Searcher) {
        this(schemaInfo, schema2Searcher, null);
    }

    @Override
    public Result search(Query query, Execution execution) {
        this.validateQueryTimeout(query);
        this.validateQueryCache(query);
        if (this.schema2Searcher.isEmpty()) {
            return new Result(query, ErrorMessage.createNoBackendsInService("Could not search"));
        }
        if (query.getTimeLeft() <= 0L) {
            return new Result(query, ErrorMessage.createTimeout("No time left for searching"));
        }
        return this.doSearch(query);
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        this.fill(result, summaryClass);
    }

    private void fill(Result result, String summaryClass) {
        Collection servers;
        Query query = result.getQuery();
        Set<String> restrict = query.getModel().getRestrict();
        Collection collection = restrict != null && !restrict.isEmpty() ? (Collection)query.getModel().getRestrict().stream().map(this.schema2Searcher::get).collect(Collectors.toCollection(TinyIdentitySet::new)) : (servers = (Collection)this.schema2Searcher.values().stream().collect(Collectors.toCollection(TinyIdentitySet::new)));
        if (!servers.isEmpty()) {
            for (VespaBackend server : servers) {
                if (query.getTimeLeft() > 0L) {
                    server.fill(result, summaryClass);
                    continue;
                }
                if (result.hits().getErrorHit() != null) continue;
                result.hits().addError(ErrorMessage.createTimeout("No time left to get summaries, query timeout was " + query.getTimeout() + " ms"));
            }
        } else if (result.hits().getErrorHit() == null) {
            result.hits().addError(ErrorMessage.createNoBackendsInService("Could not fill result"));
        }
    }

    private void validateQueryTimeout(Query query) {
        if (query.getTimeout() <= this.maxQueryTimeout) {
            return;
        }
        if (query.getTrace().isTraceable(2)) {
            query.trace("Query timeout (" + query.getTimeout() + " ms) > max query timeout (" + this.maxQueryTimeout + " ms). Setting timeout to " + this.maxQueryTimeout + " ms.", 2);
        }
        query.setTimeout(this.maxQueryTimeout);
    }

    private void validateQueryCache(Query query) {
        if (!query.getRanking().getQueryCache()) {
            return;
        }
        if (query.getTimeout() <= this.maxQueryCacheTimeout) {
            return;
        }
        if (query.getTrace().isTraceable(2)) {
            query.trace("Query timeout (" + query.getTimeout() + " ms) > max query cache timeout (" + this.maxQueryCacheTimeout + " ms). Disabling query cache.", 2);
        }
        query.getRanking().setQueryCache(false);
    }

    private Result doSearch(Query query) {
        if (this.schema2Searcher.size() > 1) {
            return this.searchMultipleDocumentTypes(query);
        }
        String schema = this.schema2Searcher.keySet().iterator().next();
        query.getModel().setRestrict(schema);
        return this.perSchemaSearch(schema, query);
    }

    private Result perSchemaSearch(String schema, Query query) {
        Set<String> restrict = query.getModel().getRestrict();
        if (restrict.size() != 1) {
            throw new IllegalStateException("perSchemaSearch must always be called with 1 schema, got: " + restrict.size());
        }
        int rerankCount = this.globalPhaseRanker != null ? this.globalPhaseRanker.getRerankCount(query, schema) : 0;
        boolean useGlobalPhase = rerankCount > 0;
        int wantOffset = query.getOffset();
        int wantHits = query.getHits();
        if (useGlobalPhase) {
            ErrorMessage error = this.globalPhaseRanker.validateNoSorting(query, schema).orElse(null);
            if (error != null) {
                return new Result(query, error);
            }
            int useHits = Math.max(wantOffset + wantHits, rerankCount);
            query.setOffset(0);
            query.setHits(useHits);
        }
        Result result = this.schema2Searcher.get(schema).search(schema, query);
        if (useGlobalPhase) {
            if (query.getTrace().isTraceable(3)) {
                query.trace("Use global-phase from [" + schema + "] to re-rank " + rerankCount + " hits", 3);
            }
            this.globalPhaseRanker.rerankHits(query, result, schema);
            result.hits().trim(wantOffset, wantHits);
            query.setOffset(wantOffset);
            query.setHits(wantHits);
        }
        return result;
    }

    private static void processResult(Query query, FutureTask<Result> task, Result mergedResult) {
        try {
            Result result = task.get();
            mergedResult.mergeWith(result);
            mergedResult.hits().addAll(result.hits().asUnorderedHits());
        }
        catch (ExecutionException e) {
            mergedResult.hits().addError(ErrorMessage.createInternalServerError("Failed querying '" + String.valueOf(query.getModel().getRestrict()) + "': " + Exceptions.toMessageString((Throwable)e), e));
        }
        catch (InterruptedException e) {
            mergedResult.hits().addError(ErrorMessage.createInternalServerError("Failed querying '" + String.valueOf(query.getModel().getRestrict()) + "': " + Exceptions.toMessageString((Throwable)e)));
        }
    }

    private Result searchMultipleDocumentTypes(Query query) {
        Set<String> schemas = this.resolveSchemas(query);
        Map<String, Query> schemaQueries = this.createQueries(query, schemas);
        if (schemaQueries.size() == 1) {
            Map.Entry<String, Query> entry = schemaQueries.entrySet().iterator().next();
            return this.perSchemaSearch(entry.getKey(), entry.getValue());
        }
        Result mergedResult = new Result(query);
        ArrayList<FutureTask<Result>> pending = new ArrayList<FutureTask<Result>>(schemaQueries.size());
        for (Map.Entry<String, Query> entry : schemaQueries.entrySet()) {
            FutureTask<Result> task = new FutureTask<Result>(() -> this.perSchemaSearch((String)entry.getKey(), (Query)entry.getValue()));
            try {
                this.executor.execute(task);
                pending.add(task);
            }
            catch (RejectedExecutionException rej) {
                task.run();
                ClusterSearcher.processResult(query, task, mergedResult);
            }
        }
        for (FutureTask futureTask : pending) {
            ClusterSearcher.processResult(query, futureTask, mergedResult);
        }
        if (query.getOffset() > 0 || query.getHits() < mergedResult.hits().size()) {
            if (mergedResult.getHitOrderer() != null) {
                this.fill(mergedResult, "attributeprefetch");
            }
            mergedResult.hits().trim(query.getOffset(), query.getHits());
            query.setOffset(0);
        }
        return mergedResult;
    }

    private Set<String> resolveSourceSubset(Set<String> sources) {
        HashSet<String> candidates = new HashSet<String>();
        for (String source : sources) {
            Cluster cluster = this.schemaInfo.clusters().get(source);
            if (cluster == null) continue;
            candidates.addAll(cluster.schemas());
        }
        return (candidates.isEmpty() ? sources : candidates).stream().filter(this.schema2Searcher::containsKey).collect(Collectors.toUnmodifiableSet());
    }

    Set<String> resolveSchemas(Query query) {
        Set<String> restrict = query.getModel().getRestrict();
        if (restrict == null || restrict.isEmpty()) {
            Set<String> sources = query.getModel().getSources();
            return sources == null || sources.isEmpty() ? this.schema2Searcher.keySet() : this.resolveSourceSubset(sources);
        }
        return this.filterValidDocumentTypes(restrict);
    }

    private Set<String> filterValidDocumentTypes(Collection<String> restrict) {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        for (String docType : restrict) {
            if (docType == null || !this.schema2Searcher.containsKey(docType)) continue;
            retval.add(docType);
        }
        return retval;
    }

    private Map<String, Query> createQueries(Query query, Set<String> schemas) {
        query.getModel().getQueryTree();
        if (schemas.size() == 1) {
            String schema = schemas.iterator().next();
            query.getModel().setRestrict(schema);
            return Map.of(schema, query);
        }
        if (!schemas.isEmpty()) {
            HashMap<String, Query> schemaQueries = new HashMap<String, Query>();
            for (String schema : schemas) {
                Query q = query.clone();
                q.setOffset(0);
                q.setHits(query.getOffset() + query.getHits());
                q.getModel().setRestrict(schema);
                schemaQueries.put(schema, q);
            }
            return schemaQueries;
        }
        return Map.of();
    }

    public void deconstruct() {
        HashMap<String, VespaBackend> servers = new HashMap<String, VespaBackend>();
        for (VespaBackend server : this.schema2Searcher.values()) {
            servers.put(server.getName(), server);
        }
        for (VespaBackend server : servers.values()) {
            server.shutDown();
        }
    }
}

