/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

public class Limit {
    public static final Limit NEGATIVE_INFINITY = new Limit(Double.NEGATIVE_INFINITY, false);
    public static final Limit POSITIVE_INFINITY = new Limit(Double.POSITIVE_INFINITY, false);
    private final Number number;
    private final boolean inclusive;
    private final boolean infinite;

    public Limit(Number number, boolean inclusive) {
        this.number = number;
        this.infinite = Double.isInfinite(number.doubleValue());
        this.inclusive = inclusive || this.infinite;
    }

    public Number number() {
        return this.number;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    String toRangeStart() {
        return (this.inclusive ? "[" : "<") + (this.isInfinite() ? "" : this.number.toString());
    }

    String toRangeEnd() {
        return (this.isInfinite() ? "" : this.number.toString()) + (this.inclusive ? "]" : ">");
    }

    public Limit min(Limit other) {
        return this.isSmallerOrEqualTo(other) ? this : other;
    }

    public Limit max(Limit other) {
        return this.isLargerOrEqualTo(other) ? this : other;
    }

    public boolean isSmallerOrEqualTo(Limit other) {
        double otherNumber;
        double thisNumber = this.number().doubleValue();
        if (thisNumber == (otherNumber = other.number().doubleValue())) {
            return other.isInclusive();
        }
        return thisNumber < otherNumber;
    }

    public boolean isLargerOrEqualTo(Limit other) {
        double otherNumber;
        double thisNumber = this.number().doubleValue();
        if (thisNumber == (otherNumber = other.number().doubleValue())) {
            return other.isInclusive();
        }
        return thisNumber > otherNumber;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public String toString() {
        return String.valueOf(this.number) + " (" + (this.inclusive ? "inclusive" : "exclusive") + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Limit)) {
            return false;
        }
        Limit other = (Limit)o;
        if (Boolean.compare(other.inclusive, this.inclusive) != 0) {
            return false;
        }
        return this.number.equals(other.number);
    }

    public int hashCode() {
        return this.number.hashCode() + (this.inclusive ? 1 : 0);
    }
}

