/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.SegmentingRule;
import com.yahoo.prelude.query.SimpleIndexedItem;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class TermItem
extends SimpleIndexedItem
implements BlockItem {
    private boolean isFromQuery;
    private boolean normalizable = true;
    private boolean lowercased = false;
    private Substring origin;
    private SegmentingRule segmentingRule = SegmentingRule.LANGUAGE_DEFAULT;

    public TermItem() {
        this("");
    }

    public TermItem(String indexName) {
        this(indexName, false);
    }

    public TermItem(String indexName, boolean isFromQuery) {
        this(indexName, isFromQuery, null);
    }

    protected TermItem(String indexName, boolean isFromQuery, Substring origin) {
        this.setIndexName(indexName);
        this.isFromQuery = isFromQuery;
        this.origin = origin;
    }

    @Override
    public final int encode(ByteBuffer buffer) {
        this.encodeThis(buffer);
        return 1;
    }

    @Override
    protected final void appendBodyString(StringBuilder buffer) {
        this.appendIndexString(buffer);
        buffer.append(this.stringValue());
    }

    public abstract void setValue(String var1);

    @Override
    public abstract String getRawWord();

    @Override
    public Substring getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isFromQuery() {
        return this.isFromQuery;
    }

    public void setFromQuery(boolean isFromQuery) {
        this.isFromQuery = isFromQuery;
    }

    @Override
    public abstract boolean isWords();

    public void setOrigin(Substring origin) {
        this.origin = origin;
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("origin", this.origin);
        discloser.setValue(this.stringValue());
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    public boolean isNormalizable() {
        return this.normalizable;
    }

    public void setNormalizable(boolean normalizable) {
        this.normalizable = normalizable;
    }

    public boolean isLowercased() {
        return this.lowercased;
    }

    public void setLowercased(boolean lowercased) {
        this.lowercased = lowercased;
    }

    @Override
    public SegmentingRule getSegmentingRule() {
        return this.segmentingRule;
    }

    public void setSegmentingRule(SegmentingRule segmentingRule) {
        this.segmentingRule = segmentingRule;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TermItem other = (TermItem)o;
        if (this.isFromQuery != other.isFromQuery) {
            return false;
        }
        if (this.normalizable != other.normalizable) {
            return false;
        }
        if (this.lowercased != other.lowercased) {
            return false;
        }
        return this.segmentingRule == other.segmentingRule;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.isFromQuery, this.normalizable, this.segmentingRule, this.lowercased});
    }
}

