/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.CompoundNameChildCache;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileVisitor;
import java.util.ArrayDeque;
import java.util.Deque;

abstract class PrefixQueryProfileVisitor
extends QueryProfileVisitor {
    protected final CompoundNameChildCache cache;
    private final CompoundName prefix;
    protected CompoundName currentPrefix = CompoundName.empty;
    private final Deque<CompoundName> currentPrefixes = new ArrayDeque<CompoundName>();
    private int prefixComponentIndex = -1;

    public PrefixQueryProfileVisitor(CompoundName prefix, CompoundNameChildCache cache) {
        if (prefix == null) {
            prefix = CompoundName.empty;
        }
        this.prefix = prefix;
        this.cache = cache;
    }

    @Override
    public final void onQueryProfile(QueryProfile profile, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
        if (this.prefixComponentIndex < this.prefix.size()) {
            return;
        }
        this.onQueryProfileInsidePrefix(profile, binding, owner, variant);
    }

    protected abstract void onQueryProfileInsidePrefix(QueryProfile var1, DimensionBinding var2, QueryProfile var3, DimensionValues var4);

    @Override
    public final boolean enter(String name) {
        if (this.prefixComponentIndex++ < this.prefix.size()) {
            return true;
        }
        if (!name.isEmpty()) {
            this.currentPrefixes.push(this.currentPrefix);
            this.currentPrefix = this.cache.append(this.currentPrefix, name);
        }
        return true;
    }

    @Override
    public final void leave(String name) {
        if (--this.prefixComponentIndex < this.prefix.size()) {
            return;
        }
        if (!name.isEmpty()) {
            this.currentPrefix = this.currentPrefixes.pop();
        }
    }

    @Override
    public String getLocalKey() {
        if (this.prefixComponentIndex < this.prefix.size()) {
            return this.prefix.get(this.prefixComponentIndex);
        }
        return null;
    }
}

