// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.prelude.semantics;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of semantic-rules
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Semantic production rules
 */
public final class SemanticRulesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "fa8416d90768614c9689a3d33ce67684";
  public final static String CONFIG_DEF_NAME = "semantic-rules";
  public final static String CONFIG_DEF_NAMESPACE = "prelude.semantics";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=prelude.semantics",
    "compatibility bool default=false",
    "rulebase[].name string",
    "rulebase[].isdefault bool default=false",
    "rulebase[].automata string default=\"\"",
    "rulebase[].rules string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean compatibility = null;
    public List<Rulebase.Builder> rulebase = new ArrayList<>();

    public Builder() { }

    public Builder(SemanticRulesConfig config) {
      compatibility(config.compatibility());
      for (Rulebase r : config.rulebase()) {
        rulebase(new Rulebase.Builder(r));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.compatibility != null)
        compatibility(__superior.compatibility);
      if (!__superior.rulebase.isEmpty())
        rulebase.addAll(__superior.rulebase);
      return this;
    }

    public Builder compatibility(boolean __value) {
      compatibility = __value;
      return this;
    }

    private Builder compatibility(String __value) {
      return compatibility(Boolean.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Rulebase builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder rulebase(Rulebase.Builder __builder) {
      rulebase.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder rulebase(java.util.function.Consumer<Rulebase.Builder> __func) {
      Rulebase.Builder __inner = new Rulebase.Builder();
      __func.accept(__inner);
      rulebase.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Rulebase builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder rulebase(List<Rulebase.Builder> __builders) {
      rulebase = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SemanticRulesConfig build() {
      return new SemanticRulesConfig(this);
    }

  }

  // Whether we should use these rule bases in pre-Vespa 2.2 compatibility mode
  // TODO: Unused, remove in Vespa 9
  private final BooleanNode compatibility;
  private final InnerNodeVector<Rulebase> rulebase;

  public SemanticRulesConfig(Builder builder) {
    this(builder, true);
  }

  private SemanticRulesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "semantic-rules must be initialized: " + builder.__uninitialized);

    compatibility = (builder.compatibility == null) ?
        new BooleanNode(false) : new BooleanNode(builder.compatibility);
    rulebase = Rulebase.createVector(builder.rulebase);
  }

  /**
   * @return semantic-rules.compatibility
   */
  public boolean compatibility() {
    return compatibility.value();
  }

  /**
   * @return semantic-rules.rulebase[]
   */
  public List<Rulebase> rulebase() {
    return rulebase;
  }

  /**
   * @param i the index of the value to return
   * @return semantic-rules.rulebase[]
   */
  public Rulebase rulebase(int i) {
    return rulebase.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SemanticRulesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("semantic-rules");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents semantic-rules.rulebase[]
   */
  public final static class Rulebase extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "rules"
        ));

      private String name = null;
      private Boolean isdefault = null;
      private String automata = null;
      private String rules = null;

      public Builder() { }

      public Builder(Rulebase config) {
        name(config.name());
        isdefault(config.isdefault());
        automata(config.automata());
        rules(config.rules());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.isdefault != null)
          isdefault(__superior.isdefault);
        if (__superior.automata != null)
          automata(__superior.automata);
        if (__superior.rules != null)
          rules(__superior.rules);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder isdefault(boolean __value) {
        isdefault = __value;
        return this;
      }

      private Builder isdefault(String __value) {
        return isdefault(Boolean.valueOf(__value));
      }

      public Builder automata(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        automata = __value;
        return this;
      }


      public Builder rules(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        rules = __value;
        __uninitialized.remove("rules");
        return this;
      }


      public Rulebase build() {
        return new Rulebase(this);
      }

    }

    // The name of a rule base
    private final StringNode name;
    // Whether this rule base is the default, to be used on all queries
    // not specifying rules
    private final BooleanNode isdefault;
    // The automata file to use to look up condition references
    // not defined in the rule base. The automata file must be present
    // on all nodes getting this configuration
    private final StringNode automata;
    // The rules
    private final StringNode rules;

    public Rulebase(Builder builder) {
      this(builder, true);
    }

    private Rulebase(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "semantic-rules.rulebase[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      isdefault = (builder.isdefault == null) ?
          new BooleanNode(false) : new BooleanNode(builder.isdefault);
      automata = (builder.automata == null) ?
          new StringNode("") : new StringNode(builder.automata);
      rules = (builder.rules == null) ?
          new StringNode() : new StringNode(builder.rules);
    }

    /**
     * @return semantic-rules.rulebase[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return semantic-rules.rulebase[].isdefault
     */
    public boolean isdefault() {
      return isdefault.value();
    }

    /**
     * @return semantic-rules.rulebase[].automata
     */
    public String automata() {
      return automata.value();
    }

    /**
     * @return semantic-rules.rulebase[].rules
     */
    public String rules() {
      return rules.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Rulebase newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("rulebase");
      return changes;
    }

    private static InnerNodeVector<Rulebase> createVector(List<Builder> builders) {
        List<Rulebase> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Rulebase(b));
        }
        return new InnerNodeVector<Rulebase>(elems);
    }
  }

}
