/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.LinguisticsParameters;
import com.yahoo.language.process.StemList;
import com.yahoo.language.process.StemMode;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.DocumentFrequency;
import com.yahoo.prelude.query.Highlight;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.PrefixItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.SegmentingRule;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;

@After(value={"unblendedResult", "TermOrderRelaxation"})
@Provides(value={"Stemming"})
public class StemmingSearcher
extends Searcher {
    public static final String STEMMING = "Stemming";
    public static final CompoundName DISABLE = CompoundName.from((String)"nostemming");
    private final Linguistics linguistics;

    public StemmingSearcher(Linguistics linguistics) {
        this.linguistics = linguistics;
    }

    @Inject
    public StemmingSearcher(ComponentId id, Linguistics linguistics) {
        super(id);
        this.linguistics = linguistics;
    }

    @Override
    public Result search(Query query, Execution execution) {
        if (query.properties().getBoolean(DISABLE)) {
            return execution.search(query);
        }
        IndexFacts.Session indexFacts = execution.context().getIndexFacts().newSession(query);
        Item newRoot = this.replaceTerms(query, indexFacts);
        query.getModel().getQueryTree().setRoot(newRoot);
        query.trace(this.getFunctionName(), true, 2);
        Highlight highlight = query.getPresentation().getHighlight();
        if (highlight != null) {
            Set<String> highlightFields = highlight.getHighlightItems().keySet();
            for (String field : highlightFields) {
                StemMode stemMode = indexFacts.getIndex(field).getStemMode();
                if (stemMode == StemMode.NONE) continue;
                StemContext context = new StemContext();
                context.language = Language.ENGLISH;
                context.indexFacts = indexFacts;
                Item newHighlight = this.scan(highlight.getHighlightItems().get(field), context);
                highlight.getHighlightItems().put(field, (AndItem)newHighlight);
            }
        }
        return execution.search(query);
    }

    public String getFunctionName() {
        return STEMMING;
    }

    private Item replaceTerms(Query q, IndexFacts.Session indexFacts) {
        Language language = q.getModel().getParsingLanguage();
        if (language == Language.UNKNOWN) {
            q.trace("Language is unknown, not stemming", 3);
            return q.getModel().getQueryTree().getRoot();
        }
        StemContext context = new StemContext();
        context.isCJK = language.isCjk();
        context.language = language;
        context.indexFacts = indexFacts;
        context.reverseConnectivity = this.createReverseConnectivities(q.getModel().getQueryTree().getRoot());
        if (q.getTrace().getLevel() >= 3) {
            q.trace("Stemming with language " + String.valueOf(language) + " using " + String.valueOf(this.linguistics), 3);
        }
        return this.scan(q.getModel().getQueryTree().getRoot(), context);
    }

    private Map<Item, TaggableItem> createReverseConnectivities(Item root) {
        return this.populateReverseConnectivityMap(root, new IdentityHashMap<Item, TaggableItem>());
    }

    private Map<Item, TaggableItem> populateReverseConnectivityMap(Item root, Map<Item, TaggableItem> reverseConnectivity) {
        TaggableItem asTaggable;
        Item connectsTo;
        if (root instanceof TaggableItem && (connectsTo = (asTaggable = (TaggableItem)((Object)root)).getConnectedItem()) != null) {
            reverseConnectivity.put(connectsTo, asTaggable);
        }
        if (root instanceof CompositeItem) {
            CompositeItem c = (CompositeItem)root;
            if (!(root instanceof BlockItem)) {
                ListIterator<Item> i = c.getItemIterator();
                while (i.hasNext()) {
                    Item item = (Item)i.next();
                    this.populateReverseConnectivityMap(item, reverseConnectivity);
                }
            }
        }
        return reverseConnectivity;
    }

    private Item scan(Item item, StemContext context) {
        if (item == null) {
            return null;
        }
        boolean old = context.insidePhrase;
        if (item instanceof PhraseItem || item instanceof PhraseSegmentItem) {
            context.insidePhrase = true;
        }
        if (item instanceof BlockItem) {
            item = this.checkBlock((BlockItem)((Object)item), context);
        } else if (item instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)item;
            ListIterator<Item> i = composite.getItemIterator();
            while (i.hasNext()) {
                Item transformed;
                Item original = i.next();
                if (original == (transformed = this.scan(original, context))) continue;
                i.set(transformed);
            }
        }
        context.insidePhrase = old;
        return item;
    }

    private Item checkBlock(BlockItem item, StemContext context) {
        Index index;
        StemMode stemMode;
        if (item instanceof PrefixItem || !item.isWords()) {
            return (Item)((Object)item);
        }
        if (item.isFromQuery() && !item.isStemmed() && (stemMode = (index = context.indexFacts.getIndex(item.getIndexName())).getStemMode()) != StemMode.NONE) {
            return this.stem(item, context, index);
        }
        return (Item)((Object)item);
    }

    private Substring getOffsets(BlockItem b) {
        if (b instanceof TermItem) {
            return b.getOrigin();
        }
        if (b instanceof CompositeItem) {
            Item i = ((CompositeItem)((Object)b)).getItem(0);
            if (i instanceof TermItem) {
                return ((TermItem)i).getOrigin();
            }
            this.getLogger().log(Level.WARNING, "BlockItem '" + String.valueOf(b) + "' was a composite containing " + i.getClass().getName() + ", expected TermItem.");
        }
        return null;
    }

    private Item stem(BlockItem current, StemContext context, Index index) {
        LinguisticsParameters parameters = new LinguisticsParameters(context.language, index.getStemMode(), index.getNormalize(), index.isLowercase());
        Item blockAsItem = (Item)((Object)current);
        List segments = this.linguistics.getStemmer().stem(current.stringValue(), parameters);
        if (segments.isEmpty()) {
            return blockAsItem;
        }
        String indexName = current.getIndexName();
        Substring origin = this.getOffsets(current);
        if (segments.size() == 1) {
            TaggableItem w = this.singleWordSegment(current, (StemList)segments.get(0), index, origin);
            this.setMetaData(current, context.reverseConnectivity, w);
            return (Item)((Object)w);
        }
        CompositeItem composite = context.isCJK ? this.chooseCompositeForCJK(current, ((Item)((Object)current)).getParent(), indexName) : this.chooseComposite(current, ((Item)((Object)current)).getParent(), indexName);
        for (StemList segment : segments) {
            TaggableItem w = this.singleWordSegment(current, segment, index, origin);
            if (composite instanceof AndSegmentItem) {
                this.setSignificanceAndDocumentFrequency(w, current);
            }
            composite.addItem((Item)((Object)w));
        }
        if (composite instanceof AndSegmentItem) {
            this.andSegmentConnectivity(current, context.reverseConnectivity, composite);
        }
        this.copyAttributes(blockAsItem, composite);
        composite.lock();
        if (composite instanceof PhraseSegmentItem) {
            PhraseSegmentItem replacement = (PhraseSegmentItem)composite;
            this.setSignificanceAndDocumentFrequency(replacement, current);
            this.phraseSegmentConnectivity(current, context.reverseConnectivity, replacement);
        }
        return composite;
    }

    private void phraseSegmentConnectivity(BlockItem current, Map<Item, TaggableItem> reverseConnectivity, PhraseSegmentItem replacement) {
        Connectivity c = this.getConnectivity(current);
        if (c != null) {
            replacement.setConnectivity(c.word, c.value);
            reverseConnectivity.put(c.word, replacement);
        }
        this.setConnectivity(current, reverseConnectivity, replacement);
    }

    private void andSegmentConnectivity(BlockItem current, Map<Item, TaggableItem> reverseConnectivity, CompositeItem composite) {
        TaggableItem w;
        Connectivity connectivity = this.getConnectivity(current);
        if (connectivity != null && (w = this.lastWord(composite)) != null) {
            w.setConnectivity(connectivity.word, connectivity.value);
            reverseConnectivity.put(connectivity.word, w);
        }
        if ((w = this.firstWord(composite)) != null) {
            this.setConnectivity(current, reverseConnectivity, (Item)((Object)w));
        }
    }

    private Connectivity getConnectivity(BlockItem current) {
        if (!(current instanceof TaggableItem)) {
            return null;
        }
        TaggableItem t = (TaggableItem)((Object)current);
        if (t.getConnectedItem() == null) {
            return null;
        }
        return new Connectivity(t.getConnectedItem(), t.getConnectivity());
    }

    private TaggableItem firstWord(CompositeItem composite) {
        int l = composite.getItemCount();
        if (l == 0) {
            return null;
        }
        return (TaggableItem)((Object)composite.getItem(0));
    }

    private TaggableItem lastWord(CompositeItem composite) {
        int l = composite.getItemCount();
        if (l == 0) {
            return null;
        }
        return (TaggableItem)((Object)composite.getItem(l - 1));
    }

    private TaggableItem singleWordSegment(BlockItem current, StemList segment, Index index, Substring origin) {
        String indexName = current.getIndexName();
        if (index.getLiteralBoost() || index.getStemMode() == StemMode.ALL) {
            ArrayList<WordAlternativesItem.Alternative> terms = new ArrayList<WordAlternativesItem.Alternative>(segment.size() + 1);
            Optional original = segment.getOrigin();
            terms.add(new WordAlternativesItem.Alternative(original.orElse(current.stringValue()), 1.0));
            for (String term : segment) {
                terms.add(new WordAlternativesItem.Alternative(term, 0.7));
            }
            WordAlternativesItem alternatives = new WordAlternativesItem(indexName, current.isFromQuery(), origin, terms);
            if (alternatives.getAlternatives().size() > 1) {
                return alternatives;
            }
        }
        if (segment.get(0).isEmpty()) {
            return (TaggableItem)((Object)current);
        }
        return this.singleStemSegment((Item)((Object)current), segment.get(0), indexName, origin);
    }

    private void setMetaData(BlockItem current, Map<Item, TaggableItem> reverseConnectivity, TaggableItem replacement) {
        this.copyAttributes((Item)((Object)current), (Item)((Object)replacement));
        this.setSignificanceAndDocumentFrequency(replacement, current);
        Connectivity c = this.getConnectivity(current);
        if (c != null) {
            replacement.setConnectivity(c.word, c.value);
            reverseConnectivity.put(c.word, replacement);
        }
        this.setConnectivity(current, reverseConnectivity, (Item)((Object)replacement));
    }

    private TaggableItem singleStemSegment(Item blockAsItem, String stem, String indexName, Substring origin) {
        WordItem replacement = new WordItem(stem, indexName, true, origin);
        replacement.setStemmed(true);
        this.copyAttributes(blockAsItem, replacement);
        return replacement;
    }

    private void setConnectivity(BlockItem current, Map<Item, TaggableItem> reverseConnectivity, Item replacement) {
        TaggableItem connectedTo;
        if (reverseConnectivity != null && !reverseConnectivity.isEmpty() && (connectedTo = reverseConnectivity.get(current)) != null) {
            double connectivity = connectedTo.getConnectivity();
            connectedTo.setConnectivity(replacement, connectivity);
        }
    }

    private CompositeItem chooseComposite(BlockItem current, CompositeItem parent, String indexName) {
        if (parent instanceof PhraseItem || current instanceof PhraseSegmentItem) {
            return this.createPhraseSegment(current, indexName);
        }
        return this.createAndSegment(current);
    }

    private CompositeItem chooseCompositeForCJK(BlockItem current, CompositeItem parent, String indexName) {
        if (current.getSegmentingRule() == SegmentingRule.LANGUAGE_DEFAULT) {
            return this.chooseComposite(current, parent, indexName);
        }
        return switch (current.getSegmentingRule()) {
            case SegmentingRule.PHRASE -> this.createPhraseSegment(current, indexName);
            case SegmentingRule.BOOLEAN_AND -> this.createAndSegment(current);
            default -> throw new IllegalArgumentException("Unknown segmenting rule: " + String.valueOf((Object)current.getSegmentingRule()) + ". This is a bug in Vespa, as the implementation has gotten out of sync. Please create an issue.");
        };
    }

    private AndSegmentItem createAndSegment(BlockItem current) {
        AndSegmentItem composite = new AndSegmentItem(current.stringValue(), true, true);
        if (current instanceof SegmentItem) {
            SegmentItem segment = (SegmentItem)current;
            composite.shouldFoldIntoWand(segment.shouldFoldIntoWand());
        }
        return composite;
    }

    private CompositeItem createPhraseSegment(BlockItem current, String indexName) {
        PhraseSegmentItem composite = new PhraseSegmentItem(current.getRawWord(), current.stringValue(), true, true);
        composite.setIndexName(indexName);
        if (current instanceof SegmentItem) {
            SegmentItem segment = (SegmentItem)current;
            composite.shouldFoldIntoWand(segment.shouldFoldIntoWand());
        }
        return composite;
    }

    private void copyAttributes(Item blockAsItem, Item replacement) {
        this.copyWeight(blockAsItem, replacement);
        replacement.setFilter(blockAsItem.isFilter());
        replacement.setRanked(blockAsItem.isRanked());
        replacement.setPositionData(blockAsItem.usePositionData());
    }

    private void copyWeight(Item block, Item replacement) {
        int weight = this.getWeight(block);
        this.setWeight(replacement, weight);
    }

    private int getWeight(Item block) {
        if (block instanceof AndSegmentItem && ((AndSegmentItem)block).getItemCount() > 0) {
            return ((AndSegmentItem)block).getItem(0).getWeight();
        }
        return block.getWeight();
    }

    private void setWeight(Item replacement, int weight) {
        if (replacement instanceof AndSegmentItem) {
            ListIterator<Item> i = ((AndSegmentItem)replacement).getItemIterator();
            while (i.hasNext()) {
                ((Item)i.next()).setWeight(weight);
            }
        } else {
            replacement.setWeight(weight);
        }
    }

    private void setSignificanceAndDocumentFrequency(TaggableItem target, BlockItem original) {
        Optional<DocumentFrequency> documentFrequency;
        if (this.hasExplicitSignificance(original)) {
            target.setSignificance(this.getSignificance(original));
        }
        if ((documentFrequency = this.getDocumentFrequency(original)).isPresent()) {
            target.setDocumentFrequency(documentFrequency.get());
        }
    }

    private boolean hasExplicitSignificance(BlockItem blockItem) {
        if (blockItem instanceof TermItem) {
            return ((TermItem)blockItem).hasExplicitSignificance();
        }
        if (blockItem instanceof PhraseSegmentItem) {
            return ((PhraseSegmentItem)blockItem).hasExplicitSignificance();
        }
        return false;
    }

    private double getSignificance(BlockItem blockItem) {
        if (blockItem instanceof TermItem) {
            return ((TermItem)blockItem).getSignificance();
        }
        return ((PhraseSegmentItem)blockItem).getSignificance();
    }

    private Optional<DocumentFrequency> getDocumentFrequency(BlockItem blockItem) {
        if (blockItem instanceof TermItem) {
            TermItem termItem = (TermItem)blockItem;
            return termItem.getDocumentFrequency();
        }
        if (blockItem instanceof PhraseSegmentItem) {
            PhraseSegmentItem phraseSegmentItem = (PhraseSegmentItem)blockItem;
            return phraseSegmentItem.getDocumentFrequency();
        }
        return Optional.empty();
    }

    private static class StemContext {
        public boolean isCJK = false;
        public boolean insidePhrase = false;
        public Language language = null;
        public IndexFacts.Session indexFacts = null;
        public Map<Item, TaggableItem> reverseConnectivity = null;

        private StemContext() {
        }
    }

    private static class Connectivity {
        public final Item word;
        public final double value;

        public Connectivity(Item connectedItem, double connectivity) {
            this.word = connectedItem;
            this.value = connectivity;
        }
    }
}

