/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.AggregatorNode;
import com.yahoo.search.grouping.request.GroupingExpression;
import java.util.List;
import java.util.stream.Collectors;

public class QuantileAggregator
extends AggregatorNode {
    private final List<Double> quantiles;

    public QuantileAggregator(List<Number> quantiles, GroupingExpression expression) {
        this(null, null, quantiles, expression);
    }

    private QuantileAggregator(String label, Integer level, List<Number> quantiles, GroupingExpression expression) {
        super("quantiles", label, level, expression);
        this.quantiles = this.toValidatedQuantiles(quantiles);
    }

    private List<Double> toValidatedQuantiles(List<Number> quantiles) {
        if (quantiles.isEmpty()) {
            throw new IllegalArgumentException("quantiles cannot be empty");
        }
        for (Number quantile : quantiles) {
            if (quantile == null) {
                throw new IllegalArgumentException("quantile cannot be null");
            }
            if (!(quantile.doubleValue() < 0.0) && !(quantile.doubleValue() > 1.0)) continue;
            throw new IllegalArgumentException("quantile must be between 0.0 and 1.0");
        }
        return quantiles.stream().map(Number::doubleValue).distinct().sorted().toList();
    }

    public List<Double> getQuantiles() {
        return this.quantiles;
    }

    @Override
    public QuantileAggregator copy() {
        return new QuantileAggregator(this.getLabel(), this.getLevelOrNull(), List.copyOf(this.getQuantiles()), this.getExpression().copy());
    }

    @Override
    public String toString() {
        String quantileStr = this.quantiles.stream().map(String::valueOf).collect(Collectors.joining(","));
        return "quantiles([" + quantileStr + "]," + String.valueOf(this.getExpression()) + ")";
    }
}

