/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.engine;

import com.yahoo.search.pagetemplates.model.Choice;
import com.yahoo.search.pagetemplates.model.MapChoice;
import com.yahoo.search.pagetemplates.model.PageElement;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class Resolution {
    private Map<Choice, Integer> choiceResolutions = new IdentityHashMap<Choice, Integer>();
    private Map<MapChoice, Map<String, List<PageElement>>> mapChoiceResolutions = new IdentityHashMap<MapChoice, Map<String, List<PageElement>>>();

    public void addChoiceResolution(Choice choice, int alternativeIndex) {
        this.choiceResolutions.put(choice, alternativeIndex);
    }

    public void addMapChoiceResolution(MapChoice choice, Map<String, List<PageElement>> mapping) {
        this.mapChoiceResolutions.put(choice, mapping);
    }

    public int getResolution(Choice choice) {
        if (choice.alternatives().size() == 1) {
            return 0;
        }
        if (choice.isEmpty()) {
            throw new IllegalArgumentException("Cannot return a resolution of empty " + String.valueOf(choice));
        }
        Integer resolution = this.choiceResolutions.get(choice);
        if (resolution == null) {
            throw new IllegalArgumentException(String.valueOf(this) + " has no resolution of " + String.valueOf(choice));
        }
        return resolution;
    }

    public Map<String, List<PageElement>> getResolution(MapChoice choice) {
        Map<String, List<PageElement>> resolution = this.mapChoiceResolutions.get(choice);
        if (resolution == null) {
            throw new IllegalArgumentException(String.valueOf(this) + " has no resolution of " + String.valueOf(choice));
        }
        return resolution;
    }

    public String toString() {
        return "a resolution of " + this.choiceResolutions.size() + " choices";
    }
}

