/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.parser;

import com.yahoo.prelude.query.parser.AdvancedParser;
import com.yahoo.prelude.query.parser.AllParser;
import com.yahoo.prelude.query.parser.AnyParser;
import com.yahoo.prelude.query.parser.LinguisticsParser;
import com.yahoo.prelude.query.parser.PhraseParser;
import com.yahoo.prelude.query.parser.ProgrammaticParser;
import com.yahoo.prelude.query.parser.TokenizeParser;
import com.yahoo.prelude.query.parser.WebParser;
import com.yahoo.search.Query;
import com.yahoo.search.query.QueryType;
import com.yahoo.search.query.SelectParser;
import com.yahoo.search.query.parser.Parser;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.yql.YqlParser;

public final class ParserFactory {
    private ParserFactory() {
    }

    public static Parser newInstance(Query.Type type, ParserEnvironment environment) {
        return ParserFactory.newInstance(QueryType.from(type), environment);
    }

    public static Parser newInstance(QueryType type, ParserEnvironment environment) {
        type.validate();
        environment.setType(type);
        if (type.getSyntax() == QueryType.Syntax.advanced) {
            return new AdvancedParser(environment);
        }
        if (type.getSyntax() == QueryType.Syntax.json) {
            return new SelectParser(environment);
        }
        if (type.getSyntax() == QueryType.Syntax.programmatic) {
            return new ProgrammaticParser();
        }
        if (type.getSyntax() == QueryType.Syntax.web) {
            return new WebParser(environment);
        }
        if (type.getSyntax() == QueryType.Syntax.yql) {
            return new YqlParser(environment);
        }
        if (type.getSyntax() == QueryType.Syntax.none) {
            if (type.getTokenization() == QueryType.Tokenization.linguistics) {
                return new LinguisticsParser(environment);
            }
            return new TokenizeParser(environment);
        }
        if (type.getSyntax() == QueryType.Syntax.simple) {
            if (type.getComposite() == QueryType.Composite.or) {
                return new AnyParser(environment);
            }
            if (type.getComposite() == QueryType.Composite.phrase) {
                return new PhraseParser(environment);
            }
            return new AllParser(environment);
        }
        throw new IllegalStateException("Unsupported query syntax '" + String.valueOf((Object)type.getSyntax()) + "'");
    }
}

