/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileVisitor;
import com.yahoo.search.query.profile.types.FieldDescription;
import java.util.List;

final class FieldDescriptionQueryProfileVisitor
extends QueryProfileVisitor {
    private FieldDescription result = null;
    private final List<String> name;
    private int nameIndex = -1;
    private boolean enteringContent = false;

    public FieldDescriptionQueryProfileVisitor(List<String> name) {
        this.name = name;
    }

    @Override
    public String getLocalKey() {
        return this.name.get(this.nameIndex);
    }

    @Override
    public boolean enter(String name) {
        if (this.nameIndex + 2 < this.name.size()) {
            ++this.nameIndex;
            this.enteringContent = true;
        } else {
            this.enteringContent = false;
        }
        return this.enteringContent;
    }

    @Override
    public void leave(String name) {
        --this.nameIndex;
    }

    @Override
    public void onValue(String name, Object value, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
    }

    @Override
    public void onQueryProfile(QueryProfile profile, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
        if (this.enteringContent) {
            return;
        }
        if (profile.getType() == null) {
            return;
        }
        this.result = profile.getType().getField(this.name.get(this.name.size() - 1));
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    public FieldDescription result() {
        return this.result;
    }

    public String toString() {
        return "a query profile type visitor (hash " + this.hashCode() + ") with current value " + String.valueOf(this.result);
    }
}

