/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.component.provider.Freezable;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileVariant;
import com.yahoo.search.query.profile.QueryProfileVisitor;
import com.yahoo.search.query.profile.SingleValueQueryProfileVisitor;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryProfileVariants
implements Freezable,
Cloneable {
    private boolean frozen = false;
    private Map<String, FieldValues> fieldValuesByName = new HashMap<String, FieldValues>();
    private FieldValues inheritedProfiles = new FieldValues();
    private List<QueryProfileVariant> variants = new ArrayList<QueryProfileVariant>();
    private final List<String> dimensions;
    private final QueryProfile owner;

    public QueryProfileVariants(String[] dimensions, QueryProfile owner) {
        this(List.of(dimensions), owner);
    }

    public QueryProfileVariants(List<String> dimensions, QueryProfile owner) {
        this.dimensions = dimensions;
        this.owner = owner;
    }

    public void freeze() {
        if (this.frozen) {
            return;
        }
        for (FieldValues fieldValues : this.fieldValuesByName.values()) {
            fieldValues.freeze();
        }
        this.fieldValuesByName = Map.copyOf(this.fieldValuesByName);
        this.inheritedProfiles.freeze();
        Collections.sort(this.variants);
        for (QueryProfileVariant variant : this.variants) {
            variant.freeze();
        }
        this.variants = List.copyOf(this.variants);
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    void accept(boolean allowContent, QueryProfileType type, QueryProfileVisitor visitor, DimensionBinding dimensionBinding) {
        String contentName = null;
        if (allowContent) {
            contentName = visitor.getLocalKey();
        }
        if (contentName != null) {
            if (type != null) {
                contentName = type.unalias(contentName);
            }
            this.acceptSingleValue(contentName, allowContent, visitor, dimensionBinding);
        } else {
            this.acceptAllValues(allowContent, visitor, type, dimensionBinding);
        }
    }

    void acceptSingleValue(String name, boolean allowContent, QueryProfileVisitor visitor, DimensionBinding dimensionBinding) {
        FieldValues fieldValues = this.fieldValuesByName.get(name);
        if (fieldValues == null || !allowContent) {
            fieldValues = new FieldValues();
        }
        fieldValues.sort();
        this.inheritedProfiles.sort();
        int inheritedIndex = 0;
        int fieldIndex = 0;
        while (fieldIndex < fieldValues.size() || inheritedIndex < this.inheritedProfiles.size()) {
            FieldValue fieldValue = fieldValues.getIfExists(fieldIndex);
            FieldValue inheritedProfileValue = this.inheritedProfiles.getIfExists(inheritedIndex);
            if (inheritedProfileValue == null || fieldValue != null && fieldValue.compareTo(inheritedProfileValue) <= 0) {
                if (fieldValue.matches(dimensionBinding.getValues())) {
                    visitor.acceptValue(name, fieldValue.getValue(), dimensionBinding, this.owner, fieldValue.getDimensionValues());
                }
                if (visitor.isDone()) {
                    return;
                }
                ++fieldIndex;
            } else {
                if (inheritedProfileValue.matches(dimensionBinding.getValues())) {
                    List inheritedProfileList = (List)inheritedProfileValue.getValue();
                    for (QueryProfile inheritedProfile : inheritedProfileList) {
                        if (visitor.visitInherited()) {
                            inheritedProfile.accept(allowContent, visitor, dimensionBinding.createFor(inheritedProfile.getDimensions()), this.owner);
                        }
                        if (!visitor.isDone()) continue;
                        return;
                    }
                }
                ++inheritedIndex;
            }
            if (!visitor.isDone()) continue;
            return;
        }
    }

    void acceptAllValues(boolean allowContent, QueryProfileVisitor visitor, QueryProfileType type, DimensionBinding dimensionBinding) {
        if (!this.frozen) {
            Collections.sort(this.variants);
        }
        for (QueryProfileVariant variant : this.variants) {
            if (variant.matches(dimensionBinding.getValues())) {
                variant.accept(allowContent, type, visitor, dimensionBinding);
            }
            if (!visitor.isDone()) continue;
            return;
        }
    }

    public Object get(String name, QueryProfileType type, boolean allowQueryProfileResult, DimensionBinding dimensionBinding) {
        SingleValueQueryProfileVisitor visitor = new SingleValueQueryProfileVisitor(List.of(name), allowQueryProfileResult);
        visitor.enter("");
        this.accept(true, type, visitor, dimensionBinding);
        visitor.leave("");
        return visitor.getResult();
    }

    public void inherit(QueryProfile profile, DimensionValues dimensionValues) {
        this.ensureNotFrozen();
        this.getVariant(dimensionValues, true).inherit(profile);
        ArrayList<QueryProfile> inheritedAtDimensionValues = (ArrayList<QueryProfile>)this.inheritedProfiles.getExact(dimensionValues);
        if (inheritedAtDimensionValues == null) {
            inheritedAtDimensionValues = new ArrayList<QueryProfile>();
            this.inheritedProfiles.put(dimensionValues, inheritedAtDimensionValues);
        }
        inheritedAtDimensionValues.add(profile);
    }

    public void set(String fieldName, DimensionValues dimensionValues, Object value) {
        this.ensureNotFrozen();
        Object combinedValue = this.getVariant(dimensionValues, true).set(fieldName, value);
        FieldValues fieldValues = this.fieldValuesByName.get(fieldName);
        if (fieldValues == null) {
            fieldValues = new FieldValues();
            this.fieldValuesByName.put(fieldName, fieldValues);
        }
        if (combinedValue != null) {
            fieldValues.put(dimensionValues, combinedValue);
        }
    }

    public void setOverridable(String fieldName, boolean overridable, DimensionValues dimensionValues) {
        this.getVariant(dimensionValues, true).setOverridable(fieldName, overridable);
    }

    public Boolean isOverridable(String fieldName, DimensionValues dimensionValues) {
        QueryProfileVariant variant = this.getVariant(dimensionValues, false);
        if (variant == null) {
            return null;
        }
        return variant.isOverridable(fieldName);
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public Map<String, FieldValues> getFieldValues() {
        return this.fieldValuesByName;
    }

    public FieldValues getInherited() {
        return this.inheritedProfiles;
    }

    public List<QueryProfileVariant> getVariants() {
        if (this.frozen) {
            return this.variants;
        }
        return Collections.unmodifiableList(this.variants);
    }

    public QueryProfileVariants clone() {
        try {
            if (this.frozen) {
                return this;
            }
            QueryProfileVariants clone = (QueryProfileVariants)super.clone();
            clone.inheritedProfiles = this.inheritedProfiles.clone();
            clone.variants = new ArrayList<QueryProfileVariant>();
            for (QueryProfileVariant queryProfileVariant : this.variants) {
                clone.variants.add(queryProfileVariant.clone());
            }
            clone.fieldValuesByName = new HashMap<String, FieldValues>();
            for (Map.Entry entry : this.fieldValuesByName.entrySet()) {
                clone.fieldValuesByName.put((String)entry.getKey(), ((FieldValues)entry.getValue()).clone((String)entry.getKey(), clone.variants));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException(String.valueOf(this) + " is frozen and cannot be modified");
        }
    }

    public QueryProfileVariant getVariant(DimensionValues dimensionValues, boolean create) {
        for (QueryProfileVariant profileVariant : this.variants) {
            if (!profileVariant.getDimensionValues().equals(dimensionValues)) continue;
            return profileVariant;
        }
        if (!create) {
            return null;
        }
        QueryProfileVariant variant = new QueryProfileVariant(dimensionValues, this.owner);
        this.variants.add(variant);
        return variant;
    }

    public String toString() {
        return "variants of " + String.valueOf(this.owner);
    }

    public static class FieldValues
    implements Freezable,
    Cloneable {
        private List<FieldValue> resolutionList = null;
        private boolean frozen = false;

        public void freeze() {
            if (this.frozen) {
                return;
            }
            this.sort();
            if (this.resolutionList != null) {
                this.resolutionList = List.copyOf(this.resolutionList);
            }
            this.frozen = true;
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public void put(DimensionValues dimensionValues, Object value) {
            FieldValue fieldValue;
            this.ensureNotFrozen();
            if (this.resolutionList == null) {
                this.resolutionList = new ArrayList<FieldValue>();
            }
            if ((fieldValue = this.getExactFieldValue(dimensionValues)) != null) {
                fieldValue.setValue(value);
            } else {
                this.resolutionList.add(new FieldValue(dimensionValues, value));
            }
        }

        public Object getExact(DimensionValues dimensionValues) {
            FieldValue value = this.getExactFieldValue(dimensionValues);
            if (value == null) {
                return null;
            }
            return value.getValue();
        }

        private FieldValue getExactFieldValue(DimensionValues dimensionValues) {
            for (FieldValue fieldValue : this.asList()) {
                if (!fieldValue.getDimensionValues().equals(dimensionValues)) continue;
                return fieldValue;
            }
            return null;
        }

        public List<FieldValue> asList() {
            if (this.resolutionList == null) {
                return List.of();
            }
            return this.resolutionList;
        }

        public FieldValue getIfExists(int index) {
            if (index >= this.size()) {
                return null;
            }
            return this.resolutionList.get(index);
        }

        public void sort() {
            if (this.frozen) {
                return;
            }
            if (this.resolutionList != null) {
                Collections.sort(this.resolutionList);
            }
        }

        public int size() {
            if (this.resolutionList == null) {
                return 0;
            }
            return this.resolutionList.size();
        }

        protected void ensureNotFrozen() {
            if (this.frozen) {
                throw new IllegalStateException(String.valueOf(this) + " is frozen and cannot be modified");
            }
        }

        public FieldValues clone(String fieldName, List<QueryProfileVariant> clonedVariants) {
            try {
                if (this.frozen) {
                    return this;
                }
                FieldValues clone = (FieldValues)super.clone();
                if (this.resolutionList != null) {
                    clone.resolutionList = new ArrayList<FieldValue>(this.resolutionList.size());
                    for (FieldValue value : this.resolutionList) {
                        clone.resolutionList.add(value.clone(fieldName, clonedVariants));
                    }
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public FieldValues clone() {
            try {
                if (this.frozen) {
                    return this;
                }
                FieldValues clone = (FieldValues)super.clone();
                if (this.resolutionList != null) {
                    clone.resolutionList = new ArrayList<FieldValue>(this.resolutionList.size());
                    for (FieldValue value : this.resolutionList) {
                        clone.resolutionList.add(value.clone());
                    }
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class FieldValue
    implements Comparable<FieldValue>,
    Cloneable {
        private final DimensionValues dimensionValues;
        private Object value;

        public FieldValue(DimensionValues dimensionValues, Object value) {
            this.dimensionValues = dimensionValues;
            this.value = value;
        }

        public DimensionValues getDimensionValues() {
            return this.dimensionValues;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean matches(DimensionValues givenDimensionValues) {
            return this.dimensionValues.matches(givenDimensionValues);
        }

        @Override
        public int compareTo(FieldValue other) {
            return this.dimensionValues.compareTo(other.dimensionValues);
        }

        public FieldValue clone(String fieldName, List<QueryProfileVariant> clonedVariants) {
            try {
                FieldValue clone = (FieldValue)super.clone();
                if (this.value instanceof QueryProfile) {
                    clone.value = this.lookupInVariants(fieldName, this.dimensionValues, clonedVariants);
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public FieldValue clone() {
            try {
                FieldValue clone = (FieldValue)super.clone();
                clone.value = QueryProfile.cloneIfNecessary(this.value);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private Object lookupInVariants(String fieldName, DimensionValues dimensionValues, List<QueryProfileVariant> variants) {
            for (QueryProfileVariant variant : variants) {
                if (!variant.getDimensionValues().equals(dimensionValues)) continue;
                return variant.values().get(fieldName);
            }
            return null;
        }

        public String toString() {
            return "field value " + String.valueOf(this.value) + " for " + String.valueOf(this.dimensionValues);
        }
    }
}

