/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.sourceref;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class VirtualSourceResolver {
    private final Map<String, Set<String>> virtualSources;

    private VirtualSourceResolver(Map<String, Set<String>> virtualSources) {
        this.virtualSources = virtualSources;
    }

    public static VirtualSourceResolver of() {
        return new VirtualSourceResolver(Map.of());
    }

    public static VirtualSourceResolver of(Set<String> targets) {
        return new VirtualSourceResolver(VirtualSourceResolver.createVirtualSources(targets));
    }

    private static Map<String, Set<String>> createVirtualSources(Set<String> targets) {
        Set virtualSources = targets.stream().filter(id -> id.contains(".")).map(id -> id.substring(0, id.indexOf(46))).collect(Collectors.toUnmodifiableSet());
        if (virtualSources.isEmpty()) {
            return Map.of();
        }
        HashMap<String, Set<String>> virtualSourceMap = new HashMap<String, Set<String>>();
        for (String virtualSource : virtualSources) {
            String prefix = virtualSource + ".";
            Set sources = targets.stream().filter(id -> id.startsWith(prefix)).collect(Collectors.toUnmodifiableSet());
            virtualSourceMap.put(virtualSource, sources);
        }
        return virtualSourceMap;
    }

    public Set<String> resolve(Set<String> sourcesInQuery) {
        boolean hasMapping = sourcesInQuery.stream().anyMatch(this.virtualSources::containsKey);
        if (hasMapping) {
            HashSet<String> resolved = new HashSet<String>();
            for (String source : sourcesInQuery) {
                Set<String> subSources = this.virtualSources.get(source);
                if (subSources != null) {
                    resolved.addAll(subSources);
                    continue;
                }
                resolved.add(source);
            }
            return resolved;
        }
        return sourcesInQuery;
    }
}

