/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.CompoundNameChildCache;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.PrefixQueryProfileVisitor;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.compiled.ValueWithSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class AllValuesQueryProfileVisitor
extends PrefixQueryProfileVisitor {
    private final Map<String, ValueWithSource> values = new HashMap<String, ValueWithSource>();

    public AllValuesQueryProfileVisitor(CompoundName prefix, CompoundNameChildCache pathCache) {
        super(prefix, pathCache);
    }

    @Override
    public void onValue(String localName, Object value, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
        this.putValue(localName, value, null, owner, variant, binding);
    }

    @Override
    public void onQueryProfileInsidePrefix(QueryProfile profile, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
        this.putValue("", profile.getValue(), profile, owner, variant, binding);
    }

    private void putValue(String key, Object value, QueryProfile profile, QueryProfile owner, DimensionValues variant, DimensionBinding binding) {
        CompoundName fullName = this.cache.append(this.currentPrefix, key);
        ValueWithSource existing = this.values.get(fullName.toString());
        if (existing != null && (existing.value() != null || value == null)) {
            return;
        }
        Boolean isOverridable = owner != null ? owner.isLocalOverridable(key, binding) : null;
        this.values.put(fullName.toString(), new ValueWithSource(value, owner == null ? "anonymous" : owner.getSource(), isOverridable != null && isOverridable == false, profile != null, profile == null ? null : profile.getType(), variant));
    }

    public Map<String, Object> values() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, ValueWithSource> entry : this.values.entrySet()) {
            values.put(entry.getKey(), entry.getValue().value());
        }
        return values;
    }

    public Map<String, ValueWithSource> valuesWithSource() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

