/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.language.Language;
import com.yahoo.language.process.Embedder;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.properties.PropertyMap;
import java.util.Map;

public class ConversionContext {
    private final String destination;
    private final CompiledQueryProfileRegistry registry;
    private final Map<String, Embedder> embedders;
    private final Map<String, String> contextValues;
    private final Properties properties;
    private final Language language;

    public ConversionContext(String destination, CompiledQueryProfileRegistry registry, Embedder embedder, Map<String, String> context, Properties properties) {
        this(destination, registry, Map.of("default", embedder), context, properties);
    }

    public ConversionContext(String destination, CompiledQueryProfileRegistry registry, Map<String, Embedder> embedders, Map<String, String> context, Properties properties) {
        this.destination = destination;
        this.registry = registry;
        this.embedders = embedders;
        Object language = context.get("language");
        if (language == null) {
            language = properties.get("language", context);
        }
        this.language = language != null ? Language.fromLanguageTag((String)language.toString()) : Language.UNKNOWN;
        this.contextValues = context;
        this.properties = properties;
    }

    public String destination() {
        return this.destination;
    }

    CompiledQueryProfileRegistry registry() {
        return this.registry;
    }

    Map<String, Embedder> embedders() {
        return this.embedders;
    }

    Language language() {
        return this.language;
    }

    Map<String, String> contextValues() {
        return this.contextValues;
    }

    Properties properties() {
        return this.properties;
    }

    public static ConversionContext empty() {
        return new ConversionContext(null, null, Embedder.throwsOnUse.asMap(), Map.of(), (Properties)new PropertyMap());
    }
}

