/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.properties;

import com.yahoo.api.annotations.Beta;
import com.yahoo.language.process.Embedder;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.properties.IllegalAssignmentException;
import com.yahoo.search.query.ranking.RankFeatures;
import com.yahoo.search.schema.RankProfile;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.schema.internal.TensorConverter;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Map;

@Beta
public class RankProfileInputProperties
extends Properties {
    private final SchemaInfo schemaInfo;
    private final Query query;
    private final TensorConverter tensorConverter;
    private SchemaInfo.Session session = null;

    public RankProfileInputProperties(SchemaInfo schemaInfo, Query query, Map<String, Embedder> embedders) {
        this.schemaInfo = schemaInfo;
        this.query = query;
        this.tensorConverter = new TensorConverter(embedders);
    }

    public void set(CompoundName name, Object value, Map<String, String> context) {
        if (RankFeatures.isFeatureName(name.toString())) {
            try {
                RankProfile.InputType expectedType = this.typeOf(name);
                if (expectedType != null && !expectedType.declaredString()) {
                    value = this.tensorConverter.convertTo(expectedType.tensorType(), name.last(), value, this.query.getModel().getLanguage(), context, this.query.properties());
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalAssignmentException(name, value, e);
            }
        }
        super.set(name, value, context);
    }

    @Override
    public void requireSettable(CompoundName name, Object value, Map<String, String> context) {
        RankProfile.InputType expectedType;
        if (RankFeatures.isFeatureName(name.toString()) && (expectedType = this.typeOf(name)) != null && !expectedType.declaredString()) {
            this.verifyType(name, value, expectedType.tensorType());
        }
        super.requireSettable(name, value, context);
    }

    private RankProfile.InputType typeOf(CompoundName name) {
        if (this.session == null) {
            this.session = this.schemaInfo.newSession(this.query);
        }
        return this.session.rankProfileInput(name.last(), this.query.getRanking().getProfile());
    }

    private void verifyType(CompoundName name, Object value, TensorType expectedType) {
        if (value instanceof Tensor) {
            TensorType valueType = ((Tensor)value).type();
            if (!valueType.isAssignableTo(expectedType)) {
                this.throwIllegalInput(name, value, expectedType);
            }
        } else if (expectedType.rank() > 0) {
            this.throwIllegalInput(name, value, expectedType);
        }
    }

    private void throwIllegalInput(CompoundName name, Object value, TensorType expectedType) {
        throw new IllegalAssignmentException(name, value, "This input is declared in rank profile '" + this.query.getRanking().getProfile() + "' as " + String.valueOf(expectedType));
    }
}

