/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.hitfield;

import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.simple.Value;
import com.yahoo.data.access.slime.SlimeAdapter;
import com.yahoo.prelude.hitfield.XmlRenderer;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.Slime;
import com.yahoo.slime.Type;
import com.yahoo.text.Utf8;

public class JSONString
implements Inspectable {
    private com.yahoo.data.access.Inspector value;
    private String content;
    private boolean didInitContent = false;

    public JSONString(com.yahoo.data.access.Inspector value) {
        if (value == null) {
            throw new IllegalArgumentException("JSONString does not accept null value.");
        }
        this.value = value;
    }

    public com.yahoo.data.access.Inspector inspect() {
        if (this.value == null) {
            JsonDecoder decoder = new JsonDecoder();
            Slime slime = decoder.decode(new Slime(), Utf8.toBytes((String)this.content));
            this.value = slime.get().field("error_message").valid() && slime.get().field("partial_result").valid() && slime.get().field("offending_input").valid() ? new Value.StringValue(this.content) : (slime.get().type() == Type.OBJECT || slime.get().type() == Type.ARRAY ? new SlimeAdapter((Inspector)slime.get()) : new Value.StringValue(this.content));
        }
        return this.value;
    }

    private void initContent() {
        if (this.didInitContent) {
            return;
        }
        this.didInitContent = true;
        this.content = this.value.type() == com.yahoo.data.access.Type.EMPTY ? "" : (this.value.type() == com.yahoo.data.access.Type.STRING ? this.value.asString() : this.value.toString());
    }

    public JSONString(String content) {
        if (content == null) {
            throw new IllegalArgumentException("JSONString does not accept null content.");
        }
        this.content = content;
        this.didInitContent = true;
    }

    public String toString() {
        if (this.value != null) {
            return this.renderFromInspector();
        }
        this.initContent();
        if (this.content.length() == 0) {
            return this.content;
        }
        this.inspect();
        return this.renderFromInspector();
    }

    public boolean fillWeightedSetItem(WeightedSetItem set) {
        this.initContent();
        this.inspect();
        if (this.value.type() != com.yahoo.data.access.Type.ARRAY) {
            return false;
        }
        for (com.yahoo.data.access.Inspector item : this.value.entries()) {
            if (item.entryCount() != 2) {
                return false;
            }
            if (item.entry(0).type() != com.yahoo.data.access.Type.STRING) {
                return false;
            }
            if (item.entry(1).type() != com.yahoo.data.access.Type.LONG && item.entry(1).type() != com.yahoo.data.access.Type.DOUBLE) {
                return false;
            }
            set.addToken(item.entry(0).asString(), (int)item.entry(1).asLong());
        }
        return true;
    }

    public String getContent() {
        this.initContent();
        return this.content;
    }

    public String renderFromInspector() {
        return XmlRenderer.render(new StringBuilder(), this.value).toString();
    }
}

