/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.language.Language;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.searchchain.Execution;
import java.util.ListIterator;

@After(value={"unblendedResult"})
@Before(value={"Stemming"})
@Provides(value={"TermOrderRelaxation"})
public class CJKSearcher
extends Searcher {
    public static final String TERM_ORDER_RELAXATION = "TermOrderRelaxation";

    @Override
    public Result search(Query query, Execution execution) {
        Language language = query.getModel().getParsingLanguage();
        if (!language.isCjk()) {
            return execution.search(query);
        }
        QueryTree tree = query.getModel().getQueryTree();
        tree.setRoot(this.transform(tree.getRoot(), execution.context().getIndexFacts().newSession(query)));
        query.trace("Rewriting for CJK behavior for implicit phrases", true, 2);
        return execution.search(query);
    }

    private Item transform(Item item, IndexFacts.Session indexFacts) {
        if (item instanceof PhraseItem) {
            PhraseItem phrase = (PhraseItem)item;
            if (phrase.isExplicit()) {
                return item;
            }
            if (indexFacts.getIndex(phrase.getIndexName()).isNGram()) {
                return item;
            }
            if (this.hasOverlappingTokens(phrase)) {
                return item;
            }
            AndItem replacement = new AndItem();
            ListIterator<Item> i = phrase.getItemIterator();
            while (i.hasNext()) {
                Item child = i.next();
                if (child instanceof WordItem) {
                    replacement.addItem(child);
                    continue;
                }
                if (child instanceof PhraseSegmentItem) {
                    PhraseSegmentItem asSegment = (PhraseSegmentItem)child;
                    replacement.addItem(new AndSegmentItem(asSegment));
                    continue;
                }
                replacement.addItem(child);
            }
            return replacement;
        }
        if (item instanceof PhraseSegmentItem) {
            PhraseSegmentItem segment = (PhraseSegmentItem)item;
            if (segment.isExplicit() || this.hasOverlappingTokens(segment)) {
                return item;
            }
            return new AndSegmentItem(segment);
        }
        if (item instanceof SegmentItem) {
            return item;
        }
        if (item instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)item;
            ListIterator<Item> i = composite.getItemIterator();
            while (i.hasNext()) {
                Item transformedItem;
                Item child = i.next();
                if (child == (transformedItem = this.transform(child, indexFacts)) || !composite.acceptsItemsOfType(transformedItem.getItemType())) continue;
                i.set(transformedItem);
            }
            return item;
        }
        return item;
    }

    private boolean hasOverlappingTokens(PhraseItem phrase) {
        ListIterator<Item> i = phrase.getItemIterator();
        while (i.hasNext()) {
            Item segment = (Item)i.next();
            if (!(segment instanceof PhraseSegmentItem) || !this.hasOverlappingTokens((PhraseSegmentItem)segment)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOverlappingTokens(PhraseSegmentItem segments) {
        int segmentsLength = 0;
        ListIterator<Item> i = segments.getItemIterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            if (!(item instanceof WordItem)) continue;
            WordItem wordItem = (WordItem)item;
            segmentsLength += wordItem.getWord().length();
        }
        return segmentsLength > segments.getRawWord().length();
    }
}

