/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.Query;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class Sorting
implements Cloneable {
    public static final String STRENGTH_IDENTICAL = "identical";
    public static final String STRENGTH_QUATERNARY = "quaternary";
    public static final String STRENGTH_TERTIARY = "tertiary";
    public static final String STRENGTH_SECONDARY = "secondary";
    public static final String STRENGTH_PRIMARY = "primary";
    public static final String UCA = "uca";
    public static final String RAW = "raw";
    public static final String LOWERCASE = "lowercase";
    static final String MISSING = "missing";
    private final List<FieldOrder> fieldOrders = new ArrayList<FieldOrder>(2);

    public Sorting() {
    }

    public Sorting(List<FieldOrder> fieldOrders) {
        this.fieldOrders.addAll(fieldOrders);
    }

    public Sorting(String sortSpec) {
        this.setSpec(sortSpec, null);
    }

    public Sorting(String sortSpec, Query query) {
        IndexFacts.Session session = null;
        if (query != null && query.getModel().getExecution().context().getIndexFacts() != null) {
            session = query.getModel().getExecution().context().getIndexFacts().newSession(query);
        }
        this.setSpec(sortSpec, session);
    }

    public static Sorting fromString(String sortSpec) {
        if (sortSpec == null) {
            return null;
        }
        if (sortSpec.isEmpty()) {
            return null;
        }
        return new Sorting(sortSpec);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSpec(String rawSortSpec, IndexFacts.Session indexFacts) {
        Tokenizer tokenizer = new Tokenizer(rawSortSpec);
        while (true) {
            AttributeSorter sorter;
            boolean inMissing;
            char orderMarker;
            block22: {
                String functionName;
                block23: {
                    block25: {
                        block24: {
                            if (!tokenizer.skipSpaces()) {
                                return;
                            }
                            orderMarker = tokenizer.peek();
                            if (orderMarker == '+' || orderMarker == '-') {
                                tokenizer.step();
                            }
                            functionName = tokenizer.token();
                            inMissing = false;
                            if (tokenizer.peek() == '(' && MISSING.equalsIgnoreCase(functionName)) {
                                inMissing = true;
                                tokenizer.step();
                                functionName = tokenizer.token();
                            }
                            if (tokenizer.peek() != '(') break block23;
                            tokenizer.step();
                            if (!LOWERCASE.equalsIgnoreCase(functionName)) break block24;
                            sorter = new LowerCaseSorter(this.canonic(tokenizer.token(), indexFacts));
                            tokenizer.expectChar(')');
                            break block22;
                        }
                        if (!RAW.equalsIgnoreCase(functionName)) break block25;
                        sorter = new RawSorter(this.canonic(tokenizer.token(), indexFacts));
                        tokenizer.expectChar(')');
                        break block22;
                    }
                    if (UCA.equalsIgnoreCase(functionName)) {
                        String attrName = tokenizer.token();
                        if (tokenizer.expectChars(',', ')') == ',') {
                            UcaSorter.Strength strength = UcaSorter.Strength.UNDEFINED;
                            String locale = tokenizer.token();
                            if (tokenizer.expectChars(',', ')') == ',') {
                                String s = tokenizer.token();
                                tokenizer.expectChar(')');
                                if (STRENGTH_PRIMARY.equalsIgnoreCase(s)) {
                                    strength = UcaSorter.Strength.PRIMARY;
                                } else if (STRENGTH_SECONDARY.equalsIgnoreCase(s)) {
                                    strength = UcaSorter.Strength.SECONDARY;
                                } else if (STRENGTH_TERTIARY.equalsIgnoreCase(s)) {
                                    strength = UcaSorter.Strength.TERTIARY;
                                } else if (STRENGTH_QUATERNARY.equalsIgnoreCase(s)) {
                                    strength = UcaSorter.Strength.QUATERNARY;
                                } else {
                                    if (!STRENGTH_IDENTICAL.equalsIgnoreCase(s)) {
                                        throw new IllegalInputException("Unknown collation strength: '" + s + "' in '" + rawSortSpec + "'");
                                    }
                                    strength = UcaSorter.Strength.IDENTICAL;
                                }
                            }
                            sorter = new UcaSorter(this.canonic(attrName, indexFacts), locale, strength);
                            break block22;
                        } else {
                            sorter = new UcaSorter(this.canonic(attrName, indexFacts));
                        }
                        break block22;
                    } else {
                        if (functionName.isEmpty()) {
                            throw new IllegalInputException("No sort function specified in '" + rawSortSpec + "'");
                        }
                        throw new IllegalInputException("Unknown sort function '" + functionName + "' in '" + rawSortSpec + "'");
                    }
                }
                sorter = new AttributeSorter(this.canonic(functionName, indexFacts));
            }
            Order order = Order.UNDEFINED;
            if (orderMarker == '+' || orderMarker == '-') {
                order = orderMarker == '+' ? Order.ASCENDING : Order.DESCENDING;
            }
            MissingPolicy missingPolicy = MissingPolicy.DEFAULT;
            String missingValue = null;
            if (inMissing) {
                tokenizer.expectChar(',');
                missingPolicy = Sorting.decodeMissingPolicy(tokenizer);
                if (missingPolicy == MissingPolicy.AS) {
                    tokenizer.expectChar(',');
                    missingValue = Sorting.decodeMissingValue(tokenizer);
                }
                tokenizer.expectChar(')');
            }
            this.fieldOrders.add(new FieldOrder(sorter, order, missingPolicy, missingValue));
            if (!tokenizer.valid()) continue;
            tokenizer.expectChar(' ');
        }
    }

    private static MissingPolicy decodeMissingPolicy(Tokenizer tokenizer) {
        String policyName = tokenizer.token();
        try {
            return MissingPolicy.valueOf(policyName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalInputException("Unknown missing policy '" + policyName + "' at " + tokenizer.spec());
        }
    }

    private static String decodeMissingValue(Tokenizer tokenizer) {
        if (tokenizer.peek() == '\"') {
            return tokenizer.dequoteString();
        }
        return tokenizer.token();
    }

    private String canonic(String attributeName, IndexFacts.Session indexFacts) {
        if (indexFacts == null) {
            return attributeName;
        }
        return indexFacts.getCanonicName(attributeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String space = "";
        for (FieldOrder spec : this.fieldOrders) {
            sb.append(space);
            if (spec.getSortOrder() == Order.DESCENDING) {
                sb.append("-");
            } else {
                sb.append("+");
            }
            sb.append(spec.getFieldName());
            space = " ";
        }
        return sb.toString();
    }

    public List<FieldOrder> fieldOrders() {
        return this.fieldOrders;
    }

    public Sorting clone() {
        return new Sorting(this.fieldOrders);
    }

    public int hashCode() {
        return this.fieldOrders.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sorting)) {
            return false;
        }
        Sorting ss = (Sorting)o;
        return this.fieldOrders.equals(ss.fieldOrders);
    }

    public String toSerialForm() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (FieldOrder fieldOrder : this.fieldOrders) {
            if (first) {
                first = false;
            } else {
                b.append(' ');
            }
            fieldOrder.appendSerialForm(b, true);
        }
        return b.toString();
    }

    public int encode(ByteBuffer buffer) {
        String serialForm = this.toSerialForm();
        byte[] b = serialForm.getBytes(StandardCharsets.UTF_8);
        buffer.put(b);
        return b.length;
    }

    private static class Tokenizer {
        private String spec;
        private int pos;

        public Tokenizer(String spec) {
            this.spec = spec;
            this.pos = 0;
        }

        String token() {
            char c;
            if (this.pos >= this.spec.length()) {
                return new String();
            }
            int oldPos = this.pos;
            while (this.pos < this.spec.length() && (c = this.spec.charAt(this.pos)) != ' ' && c != ',' && c != '(' && c != ')' && c != '\\' && c != '\"') {
                ++this.pos;
            }
            return this.spec.substring(oldPos, this.pos);
        }

        boolean valid() {
            return this.pos < this.spec.length();
        }

        char peek() {
            return this.pos < this.spec.length() ? this.spec.charAt(this.pos) : (char)'\u0000';
        }

        void step() {
            if (this.valid()) {
                ++this.pos;
            }
        }

        boolean skipSpaces() {
            while (this.valid() && this.spec.charAt(this.pos) == ' ') {
                ++this.pos;
            }
            return this.valid();
        }

        String spec() {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            builder.append(this.spec.substring(0, this.pos));
            builder.append(']');
            builder.append('[');
            builder.append(this.spec.substring(this.pos));
            builder.append(']');
            return builder.toString();
        }

        void expectChar(char expected) {
            if (!this.valid()) {
                throw new IllegalInputException("Expected '" + expected + "', end of spec reached at " + this.spec());
            }
            char act = this.peek();
            if (act != expected) {
                throw new IllegalInputException("Expected '" + expected + "', got '" + act + "' at " + this.spec());
            }
            this.step();
        }

        char expectChars(char expected1, char expected2) {
            if (!this.valid()) {
                throw new IllegalInputException("Expected '" + expected1 + "' or '" + expected2 + "', end of spec reached at " + this.spec());
            }
            char act = this.peek();
            if (act != expected1 && act != expected2) {
                throw new IllegalInputException("Expected '" + expected1 + "' or '" + expected2 + "', got '" + act + "' at " + this.spec());
            }
            this.step();
            return act;
        }

        String dequoteString() {
            StringBuilder b = new StringBuilder();
            this.expectChar('\"');
            while (this.valid() && this.peek() != '\"') {
                String fragment = this.token();
                b.append(fragment);
                if (!this.valid()) continue;
                char c = this.peek();
                if (c == '\\') {
                    this.step();
                    c = this.expectChars('\\', '\"');
                    b.append(c);
                    continue;
                }
                if (c == '\"') continue;
                b.append(c);
                this.step();
            }
            this.expectChar('\"');
            return b.toString();
        }
    }

    public static class LowerCaseSorter
    extends AttributeSorter {
        public LowerCaseSorter(String fieldName) {
            super(fieldName);
        }

        @Override
        public String toSerialForm() {
            return "lowercase(" + this.getName() + ")";
        }

        @Override
        public int hashCode() {
            return 1 + 3 * super.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof LowerCaseSorter)) {
                return false;
            }
            return super.equals(other);
        }

        @Override
        public int compare(Comparable a, Comparable b) {
            if (a instanceof String && b instanceof String) {
                return ((String)((Object)a)).compareToIgnoreCase((String)((Object)b));
            }
            return a.compareTo(b);
        }
    }

    public static class RawSorter
    extends AttributeSorter {
        public RawSorter(String fieldName) {
            super(fieldName);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof RawSorter)) {
                return false;
            }
            return super.equals(other);
        }
    }

    public static class UcaSorter
    extends AttributeSorter {
        private String locale = null;
        private Strength strength = Strength.UNDEFINED;
        private Collator collator;

        public UcaSorter(String fieldName, String locale, Strength strength) {
            super(fieldName);
            this.setLocale(locale, strength);
        }

        public UcaSorter(String fieldName) {
            super(fieldName);
        }

        private static int strength2Collator(Strength strength) {
            return switch (strength) {
                default -> throw new IncompatibleClassChangeError();
                case Strength.PRIMARY -> 0;
                case Strength.SECONDARY -> 1;
                case Strength.TERTIARY -> 2;
                case Strength.QUATERNARY -> 3;
                case Strength.IDENTICAL -> 15;
                case Strength.UNDEFINED -> 0;
            };
        }

        public void setLocale(String locale, Strength strength) {
            ULocale uloc;
            this.locale = locale;
            this.strength = strength;
            try {
                uloc = new ULocale(locale);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("ULocale '" + locale + "' failed", e);
            }
            try {
                this.collator = Collator.getInstance((ULocale)uloc);
                if (this.collator == null) {
                    throw new IllegalArgumentException("No collator available for locale '" + locale + "'");
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Collator.getInstance(ULocale(" + locale + ")) failed", e);
            }
            this.collator.setStrength(UcaSorter.strength2Collator(strength));
        }

        public String getLocale() {
            return this.locale;
        }

        public Strength getStrength() {
            return this.strength;
        }

        Collator getCollator() {
            return this.collator;
        }

        public String getDecomposition() {
            return this.collator.getDecomposition() == 17 ? "CANONICAL_DECOMPOSITION" : "NO_DECOMPOSITION";
        }

        @Override
        public String toSerialForm() {
            return "uca(" + this.getName() + "," + this.locale + "," + (this.strength != Strength.UNDEFINED ? this.strength.toString() : "PRIMARY") + ")";
        }

        @Override
        public int hashCode() {
            return 1 + 3 * this.locale.hashCode() + 5 * this.strength.hashCode() + 7 * super.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UcaSorter)) {
                return false;
            }
            return super.equals(other) && this.locale.equals(((UcaSorter)other).locale) && this.strength == ((UcaSorter)other).strength;
        }

        @Override
        public UcaSorter clone() {
            UcaSorter clone = (UcaSorter)super.clone();
            if (this.locale != null) {
                clone.setLocale(this.locale, this.strength);
            }
            return clone;
        }

        @Override
        public int compare(Comparable a, Comparable b) {
            if (a instanceof String && b instanceof String) {
                return this.collator.compare((String)((Object)a), (String)((Object)b));
            }
            return a.compareTo(b);
        }

        public static enum Strength {
            PRIMARY,
            SECONDARY,
            TERTIARY,
            QUATERNARY,
            IDENTICAL,
            UNDEFINED;

        }
    }

    public static class AttributeSorter
    implements Cloneable {
        private static final Pattern legalAttributeName = Pattern.compile("[\\[]*[a-zA-Z_][\\.a-zA-Z0-9_-]*[\\]]*");
        private String fieldName;

        public AttributeSorter(String fieldName) {
            if (!legalAttributeName.matcher(fieldName).matches()) {
                throw new IllegalInputException("Illegal attribute name '" + fieldName + "' for sorting. Requires '" + legalAttributeName.pattern() + "'");
            }
            this.fieldName = fieldName;
        }

        public String getName() {
            return this.fieldName;
        }

        public void setName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toSerialForm() {
            return this.fieldName;
        }

        public String toString() {
            return this.toSerialForm();
        }

        public int hashCode() {
            return this.fieldName.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof AttributeSorter)) {
                return false;
            }
            AttributeSorter sorter = (AttributeSorter)other;
            return sorter.fieldName.equals(this.fieldName);
        }

        public AttributeSorter clone() {
            try {
                return (AttributeSorter)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public int compare(Comparable a, Comparable b) {
            return a.compareTo(b);
        }
    }

    public static enum Order {
        ASCENDING,
        DESCENDING,
        UNDEFINED;

    }

    static enum MissingPolicy {
        DEFAULT("default"),
        FIRST("first"),
        LAST("last"),
        AS("as");

        private final String name;

        private MissingPolicy(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }

    public static class FieldOrder
    implements Cloneable {
        private AttributeSorter fieldSorter;
        private Order sortOrder;
        private MissingValueSettings missingValueSettings;

        public FieldOrder(AttributeSorter fieldSorter, Order sortOrder) {
            this(fieldSorter, sortOrder, MissingPolicy.DEFAULT, null);
        }

        FieldOrder(AttributeSorter fieldSorter, Order sortOrder, MissingPolicy missingPolicy, String missingValue) {
            this.fieldSorter = fieldSorter;
            this.sortOrder = sortOrder;
            this.missingValueSettings = new MissingValueSettings(missingPolicy, missingValue);
        }

        public String getFieldName() {
            return this.fieldSorter.getName();
        }

        public AttributeSorter getSorter() {
            return this.fieldSorter;
        }

        public void setSorter(AttributeSorter sorter) {
            this.fieldSorter = sorter;
        }

        public Order getSortOrder() {
            return this.sortOrder;
        }

        MissingValueSettings getMissingValueSettings() {
            return this.missingValueSettings;
        }

        void appendSerialForm(StringBuilder b, boolean includeOrder) {
            boolean emitMissingFunction;
            if (includeOrder) {
                if (this.sortOrder == Order.ASCENDING) {
                    b.append('+');
                } else {
                    b.append('-');
                }
            }
            if (emitMissingFunction = this.missingValueSettings.hasNondefaultSetting()) {
                this.missingValueSettings.appendPrefix(b);
            }
            b.append(this.fieldSorter.toSerialForm());
            if (emitMissingFunction) {
                this.missingValueSettings.appendSuffix(b);
            }
        }

        public String toSerialForm(boolean includeOrder) {
            StringBuilder b = new StringBuilder();
            this.appendSerialForm(b, includeOrder);
            return b.toString();
        }

        public void setAscending(boolean asc) {
            this.sortOrder = asc ? Order.ASCENDING : Order.DESCENDING;
        }

        public String toString() {
            return this.sortOrder.toString() + ":" + this.toSerialForm(false);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sortOrder, this.fieldSorter, this.missingValueSettings});
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldOrder)) {
                return false;
            }
            FieldOrder other = (FieldOrder)o;
            return other.sortOrder.equals((Object)this.sortOrder) && other.fieldSorter.equals(this.fieldSorter) && other.missingValueSettings.equals(this.missingValueSettings);
        }

        public FieldOrder clone() {
            return new FieldOrder(this.fieldSorter.clone(), this.sortOrder, this.missingValueSettings.getPolicy(), this.missingValueSettings.getMissingValue());
        }
    }

    private static class MissingValueSettings {
        private MissingPolicy missingPolicy;
        private String missingValue;

        MissingValueSettings(MissingPolicy missingPolicy, String missingValue) {
            this.missingPolicy = missingPolicy;
            this.missingValue = missingValue;
        }

        boolean hasNondefaultSetting() {
            return this.missingPolicy != MissingPolicy.DEFAULT;
        }

        void appendPrefix(StringBuilder b) {
            b.append("missing(");
        }

        static boolean needQuotes(String value) {
            if (value.isEmpty()) {
                return true;
            }
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c != ' ' && c != ',' && c != '(' && c != ')' && c != '\\' && c != '\"') continue;
                return true;
            }
            return false;
        }

        static void appendQuoted(StringBuilder b, String value) {
            b.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\\' || c == '\"') {
                    b.append('\\');
                }
                b.append(c);
            }
            b.append('\"');
        }

        void appendMissingValue(StringBuilder b) {
            if (this.missingValue == null) {
                b.append("\"\"");
            } else if (MissingValueSettings.needQuotes(this.missingValue)) {
                MissingValueSettings.appendQuoted(b, this.missingValue);
            } else {
                b.append(this.missingValue);
            }
        }

        void appendSuffix(StringBuilder b) {
            b.append(',');
            b.append(this.missingPolicy.getName());
            if (this.missingPolicy == MissingPolicy.AS) {
                b.append(",");
                this.appendMissingValue(b);
            }
            b.append(')');
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.missingPolicy, this.missingValue});
        }

        public boolean equals(Object o) {
            if (!(o instanceof MissingValueSettings)) {
                return false;
            }
            MissingValueSettings other = (MissingValueSettings)o;
            if (this.missingPolicy != other.missingPolicy) {
                return false;
            }
            if (this.missingValue == null) {
                return other.missingValue == null;
            }
            if (other.missingValue == null) {
                return false;
            }
            return this.missingValue.equals(other.missingValue);
        }

        MissingPolicy getPolicy() {
            return this.missingPolicy;
        }

        String getMissingValue() {
            return this.missingValue;
        }
    }
}

