/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.Location;
import com.yahoo.prelude.query.GeoLocationItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import java.util.List;

@After(value={"rawQuery", "PositionParsing"})
@Before(value={"transformedQuery"})
public class DefaultPositionSearcher
extends Searcher {
    @Inject
    public DefaultPositionSearcher(DocumentmanagerConfig cfg) {
    }

    @Override
    public Result search(Query query, Execution execution) {
        Location location = query.getRanking().getLocation();
        if (location != null && location.getAttribute() == null) {
            IndexFacts facts = execution.context().getIndexFacts();
            List<String> search = facts.newSession(query.getModel().getSources(), query.getModel().getRestrict()).documentTypes();
            for (String sd : search) {
                String defaultPosition = facts.getDefaultPosition(sd);
                if (defaultPosition == null) continue;
                location.setAttribute(defaultPosition);
            }
            if (location.getAttribute() == null) {
                location.setAttribute(facts.getDefaultPosition(null));
            }
        }
        if (location != null && location.getAttribute() != null) {
            GeoLocationItem geoLoc = new GeoLocationItem(location);
            if (location.isGeoCircle() && location.degRadius() < 0.0) {
                query.getModel().getQueryTree().withRank(geoLoc);
            } else {
                query.getModel().getQueryTree().and(geoLoc);
            }
            location = null;
            query.getRanking().setLocation(location);
        }
        return execution.search(query);
    }
}

