/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import ai.vespa.modelintegration.evaluator.OnnxRuntime;
import ai.vespa.models.evaluation.Model;
import ai.vespa.models.evaluation.ModelsEvaluator;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.search.ranking.GlobalPhaseSetup;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class RankProfilesEvaluator
extends AbstractComponent {
    private final ModelsEvaluator evaluator;
    private final Map<String, GlobalPhaseSetup> profilesWithGlobalPhase = new HashMap<String, GlobalPhaseSetup>();

    @Inject
    public RankProfilesEvaluator(RankProfilesConfig rankProfilesConfig, RankingConstantsConfig constantsConfig, RankingExpressionsConfig expressionsConfig, OnnxModelsConfig onnxModelsConfig, FileAcquirer fileAcquirer, OnnxRuntime onnxRuntime) {
        this.evaluator = new ModelsEvaluator(rankProfilesConfig, constantsConfig, expressionsConfig, onnxModelsConfig, fileAcquirer, onnxRuntime);
        this.extractGlobalPhaseData(rankProfilesConfig);
    }

    public Model modelForRankProfile(String rankProfile) {
        Model m = (Model)this.evaluator.models().get(rankProfile);
        if (m == null) {
            throw new IllegalArgumentException("unknown rankprofile: " + rankProfile);
        }
        return m;
    }

    Optional<GlobalPhaseSetup> getGlobalPhaseSetup(String rankProfile) {
        return Optional.ofNullable(this.profilesWithGlobalPhase.get(rankProfile));
    }

    private void extractGlobalPhaseData(RankProfilesConfig rankProfilesConfig) {
        for (RankProfilesConfig.Rankprofile rp : rankProfilesConfig.rankprofile()) {
            GlobalPhaseSetup setup = GlobalPhaseSetup.maybeMakeSetup(rp, this);
            if (setup == null) continue;
            this.profilesWithGlobalPhase.put(rp.name(), setup);
        }
    }
}

