/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.ToProtobuf;
import com.yahoo.prelude.query.WeightedSetItem;
import java.util.Iterator;
import java.util.Map;

public class DotProductItem
extends WeightedSetItem {
    public DotProductItem(String indexName) {
        super(indexName);
    }

    public DotProductItem(String indexName, Map<Object, Integer> map) {
        super(indexName, map);
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.DOTPRODUCT;
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        if (this.hasOnlyLongs()) {
            SearchProtocol.ItemDotProductOfLong.Builder builder = SearchProtocol.ItemDotProductOfLong.newBuilder();
            builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
            Iterator<Map.Entry<Object, Integer>> it = this.getTokens();
            while (it.hasNext()) {
                Map.Entry<Object, Integer> entry = it.next();
                SearchProtocol.PureWeightedLong weightedLong = SearchProtocol.PureWeightedLong.newBuilder().setWeight(entry.getValue().intValue()).setValue(((Long)entry.getKey()).longValue()).build();
                builder.addWeightedLongs(weightedLong);
            }
            return SearchProtocol.QueryTreeItem.newBuilder().setItemDotProductOfLong(builder.build()).build();
        }
        SearchProtocol.ItemDotProductOfString.Builder builder = SearchProtocol.ItemDotProductOfString.newBuilder();
        builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
        Iterator<Map.Entry<Object, Integer>> it = this.getTokens();
        while (it.hasNext()) {
            Map.Entry<Object, Integer> entry = it.next();
            SearchProtocol.PureWeightedString weightedString = SearchProtocol.PureWeightedString.newBuilder().setWeight(entry.getValue().intValue()).setValue(entry.getKey().toString()).build();
            builder.addWeightedStrings(weightedString);
        }
        return SearchProtocol.QueryTreeItem.newBuilder().setItemDotProductOfString(builder.build()).build();
    }
}

