/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.language.LinguisticsCase;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.WordItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Highlight
implements Cloneable {
    public static final String HIGHLIGHTTERMS = "highlightterms";
    private Map<String, AndItem> highlightItems = new LinkedHashMap<String, AndItem>();
    private Map<String, List<String>> highlightTerms = new LinkedHashMap<String, List<String>>();

    private void addHighlightItem(String key, Item value) {
        AndItem item = this.highlightItems.get(key);
        if (item == null) {
            item = new AndItem();
            this.highlightItems.put(key, item);
        }
        item.addItem(value);
    }

    public void addHighlightTerm(String field, String item) {
        this.addHighlightItem(field, new WordItem(LinguisticsCase.toLowerCase((String)item), field, true));
    }

    public void addHighlightPhrase(String field, List<String> phrase) {
        PhraseItem pi = new PhraseItem();
        pi.setIndexName(field);
        for (String s : phrase) {
            pi.addItem(new WordItem(LinguisticsCase.toLowerCase((String)s), field, true));
        }
        this.addHighlightItem(field, pi);
    }

    public Map<String, AndItem> getHighlightItems() {
        return this.highlightItems;
    }

    public Highlight clone() {
        try {
            Highlight clone = (Highlight)super.clone();
            clone.highlightItems = new LinkedHashMap<String, AndItem>();
            for (Map.Entry<String, AndItem> entry : this.highlightItems.entrySet()) {
                clone.highlightItems.put(entry.getKey(), (AndItem)entry.getValue().clone());
            }
            clone.highlightTerms = new LinkedHashMap<String, List<String>>();
            for (Map.Entry<String, Object> entry : this.highlightTerms.entrySet()) {
                clone.highlightTerms.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, List<String>> getHighlightTerms() {
        return this.highlightTerms;
    }

    public void prepare() {
        this.highlightTerms.clear();
        for (String index : this.getHighlightItems().keySet()) {
            AndItem root = this.getHighlightItems().get(index);
            ArrayList<WordItem> words = new ArrayList<WordItem>();
            ArrayList<CompositeItem> phrases = new ArrayList<CompositeItem>();
            ListIterator<Item> i = root.getItemIterator();
            while (i.hasNext()) {
                Item item = (Item)i.next();
                if (item instanceof WordItem) {
                    words.add((WordItem)item);
                    continue;
                }
                if (!(item instanceof CompositeItem)) continue;
                phrases.add((CompositeItem)item);
            }
            ArrayList<String> terms = new ArrayList<String>();
            terms.add(String.valueOf(words.size() + phrases.size()));
            for (WordItem wordItem : words) {
                terms.add(wordItem.getWord());
            }
            for (CompositeItem compositeItem : phrases) {
                terms.add("\"");
                terms.add(String.valueOf(compositeItem.getItemCount()));
                ListIterator<Item> i2 = compositeItem.getItemIterator();
                while (i2.hasNext()) {
                    terms.add(((IndexedItem)i2.next()).getIndexedString());
                }
                terms.add("\"");
            }
            if (terms.size() <= 1) continue;
            this.highlightTerms.put(index, terms);
        }
    }
}

