/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.InvokerResult;
import com.yahoo.search.dispatch.ResponseMonitor;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorMessage;
import java.util.Optional;

public class SearchErrorInvoker
extends SearchInvoker {
    private final ErrorMessage message;
    private Query query;
    private final Coverage coverage;
    private ResponseMonitor<SearchInvoker> monitor;

    public SearchErrorInvoker(ErrorMessage message, Coverage coverage) {
        super(Optional.empty());
        this.message = message;
        this.coverage = coverage;
    }

    public SearchErrorInvoker(ErrorMessage message) {
        this(message, null);
    }

    @Override
    protected Object sendSearchRequest(Query query, Object context) {
        this.query = query;
        if (this.monitor != null) {
            this.monitor.responseAvailable(this);
        }
        return context;
    }

    @Override
    protected InvokerResult getSearchResult() {
        Result res = new Result(this.query, this.message);
        if (this.coverage != null) {
            res.setCoverage(this.coverage);
        }
        return new InvokerResult(res);
    }

    @Override
    protected void release() {
    }

    @Override
    protected void setMonitor(ResponseMonitor<SearchInvoker> monitor) {
        this.monitor = monitor;
    }
}

