/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.result.ChainableComparator;
import com.yahoo.search.result.Hit;
import java.util.Comparator;

public class FieldComparator
extends ChainableComparator {
    private final Sorting sorting;

    public FieldComparator(Sorting sorting) {
        this(sorting, null);
    }

    public FieldComparator(Sorting sorting, Comparator<Hit> secondaryComparator) {
        super(secondaryComparator);
        this.sorting = sorting;
    }

    public static FieldComparator create(Sorting sorting) {
        if (sorting == null) {
            return null;
        }
        return new FieldComparator(sorting);
    }

    @Override
    public int compare(Hit first, Hit second) {
        for (Sorting.FieldOrder fieldOrder : this.sorting.fieldOrders()) {
            Object b;
            String fieldName = fieldOrder.getFieldName();
            Object a = this.getField(first, fieldName);
            int x = this.compareValues(a, b = this.getField(second, fieldName), fieldOrder.getSorter());
            if (x == 0) continue;
            if (fieldOrder.getSortOrder() == Sorting.Order.DESCENDING) {
                x *= -1;
            }
            return x;
        }
        return super.compare(first, second);
    }

    private Object getSubField(Object field, String key) {
        if (field instanceof Inspectable) {
            Inspector sub;
            Inspector top = ((Inspectable)field).inspect();
            int firstDot = key.indexOf(46);
            if (firstDot > 0 && (sub = top.field(key.substring(0, firstDot))).valid()) {
                return this.getSubField(sub, key.substring(firstDot + 1));
            }
            sub = top.field(key);
            if (sub.valid()) {
                return switch (sub.type()) {
                    case Type.EMPTY -> null;
                    case Type.BOOL -> {
                        if (sub.asBool()) {
                            yield Boolean.TRUE;
                        }
                        yield Boolean.FALSE;
                    }
                    case Type.LONG -> sub.asLong();
                    case Type.DOUBLE -> sub.asDouble();
                    case Type.STRING -> sub.asString();
                    default -> sub.toString();
                };
            }
        }
        return field;
    }

    public Object getField(Hit hit, String key) {
        if ("[relevance]".equals(key)) {
            return hit.getRelevance();
        }
        if ("[rank]".equals(key)) {
            return hit.getRelevance();
        }
        if ("[source]".equals(key)) {
            return hit.getSource();
        }
        int firstDot = key.indexOf(46);
        if (firstDot > 0 && hit.getField(key) == null) {
            String keyPrefix = key.substring(0, firstDot);
            String keySuffix = key.substring(firstDot + 1);
            Object a = hit.getField(keyPrefix);
            Object b = this.getSubField(a, keySuffix);
            return b;
        }
        return hit.getField(key);
    }

    private int compareValues(Object first, Object second, Sorting.AttributeSorter s) {
        if (first == null) {
            return second == null ? 0 : -1;
        }
        if (second == null) {
            return 1;
        }
        if (first.getClass().isInstance(second) && first instanceof Comparable) {
            return s.compare((Comparable)first, (Comparable)second);
        }
        return s.compare((Comparable)((Object)first.toString()), (Comparable)((Object)second.toString()));
    }

    public String toString() {
        return "FieldComparator:" + (this.sorting == null ? " null" : this.sorting.toString());
    }
}

