/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.SameElementItem;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.chain.Before;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Before(value={"GroupingExecutor"})
public class ValidateSameElementSearcher
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        Optional<ErrorMessage> e = this.validate(query, execution);
        return e.isEmpty() ? execution.search(query) : new Result(query, e.get());
    }

    private Optional<ErrorMessage> validate(Query query, Execution execution) {
        SameElementVisitor visitor = new SameElementVisitor(query, execution);
        ToolBox.visit(visitor, query.getModel().getQueryTree().getRoot());
        return visitor.errorMessage;
    }

    private static class SameElementVisitor
    extends ToolBox.QueryVisitor {
        public Optional<ErrorMessage> errorMessage = Optional.empty();
        private final Query query;
        private final Execution execution;

        public SameElementVisitor(Query query, Execution execution) {
            this.query = query;
            this.execution = execution;
        }

        @Override
        public boolean visit(Item item) {
            SameElementItem sameElement;
            String error;
            if (item instanceof SameElementItem && (error = this.ensureValid(sameElement = (SameElementItem)item)) != null) {
                this.errorMessage = Optional.of(ErrorMessage.createIllegalQuery(error));
            }
            return true;
        }

        private String ensureValid(SameElementItem sameItem) {
            if (sameItem.items().stream().noneMatch(child -> child instanceof AndItem)) {
                return null;
            }
            List<Item> flattened = this.flattenedItems(sameItem);
            this.removeItems(sameItem);
            flattened.forEach(item -> sameItem.addItem((Item)item));
            return null;
        }

        private List<Item> flattenedItems(SameElementItem sameItem) {
            ArrayList<Item> flattened = new ArrayList<Item>();
            for (Item child : sameItem.items()) {
                if (child instanceof AndItem) {
                    AndItem and = (AndItem)child;
                    flattened.addAll(and.items());
                    continue;
                }
                flattened.add(child);
            }
            return flattened;
        }

        private void removeItems(SameElementItem sameItem) {
            for (int i = sameItem.getItemCount() - 1; i >= 0; --i) {
                sameItem.removeItem(i);
            }
        }
    }
}

