/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text.interpretation;

import com.yahoo.text.interpretation.Span;
import java.util.HashMap;
import java.util.Map;

public class Annotations {
    private final Span span;
    protected Map<String, Object> annotations;

    public void put(String key, Object o) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, Object>();
        }
        this.annotations.put(key, o);
    }

    public Map<String, Object> getMap() {
        if (this.annotations == null) {
            return Map.of();
        }
        return this.annotations;
    }

    public Annotations(Span span) {
        this.span = span;
    }

    public Object get(String key) {
        return this.getMap().get(key);
    }

    public Span getSpan() {
        return this.span;
    }

    public String getSubString() {
        return this.span.getText();
    }

    public Double getDouble(String key) {
        Object o = this.getMap().get(key);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o == null) {
            return null;
        }
        return Double.parseDouble(o.toString());
    }

    public String getString(String key) {
        Object o = this.getMap().get(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Integer getInteger(String key) {
        Object o = this.getMap().get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.parseInt(o.toString());
    }

    public Boolean getBoolean(String key) {
        Object o = this.getMap().get(key);
        if (!(o instanceof Boolean)) {
            return null;
        }
        return (Boolean)o;
    }
}

