/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc;

import com.yahoo.component.AbstractComponent;
import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.Field;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import java.util.Map;

public abstract class AbstractConcreteDocumentFactory
extends AbstractComponent {
    public abstract Map<String, Class<? extends Document>> documentTypes();

    public abstract Map<String, Class<? extends Struct>> structTypes();

    public abstract Map<String, Class<? extends Annotation>> annotationTypes();

    public abstract Document getDocumentCopy(String var1, StructuredFieldValue var2, DocumentId var3);

    public FieldValue optionallyUpgrade(Field field, FieldValue fv) {
        return this.optionallyUpgrade(field.getDataType(), fv);
    }

    private FieldValue optionallyUpgrade(DataType dataType, FieldValue fv) {
        MapFieldValue map;
        DataType valueTypeType;
        if (fv instanceof StructuredFieldValue) {
            try {
                return (FieldValue)this.structTypes().get(dataType.getName()).getConstructor(StructuredFieldValue.class).newInstance(fv);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (fv instanceof Array) {
            Array array = (Array)fv;
            DataType nestedType = array.getDataType().getNestedType();
            if (nestedType.getPrimitiveType() == null) {
                array.replaceAll(item -> this.optionallyUpgrade(nestedType, (FieldValue)item));
            }
        } else if (fv instanceof MapFieldValue && (valueTypeType = (map = (MapFieldValue)fv).getDataType().getValueType()).getPrimitiveType() == null) {
            map.replaceAll((key, value) -> this.optionallyUpgrade(valueTypeType, (FieldValue)value));
        }
        return fv;
    }
}

