/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ArithmeticValueUpdate;
import com.yahoo.document.update.ValueUpdate;

public class MapValueUpdate
extends ValueUpdate {
    protected FieldValue value;
    protected ValueUpdate update;

    public MapValueUpdate(FieldValue value, ValueUpdate update) {
        super(ValueUpdate.ValueUpdateClassID.MAP);
        this.value = value;
        this.update = update;
    }

    public FieldValue getValue() {
        return this.value;
    }

    public void setValue(FieldValue value) {
        this.value = value;
    }

    public ValueUpdate getUpdate() {
        return this.update;
    }

    @Override
    public FieldValue applyTo(FieldValue fval) {
        if (fval instanceof Array) {
            Array array = (Array)fval;
            FieldValue element = array.getFieldValue(((IntegerFieldValue)this.value).getInteger());
            element = this.update.applyTo(element);
            array.set(((IntegerFieldValue)this.value).getInteger(), element);
        } else if (fval instanceof WeightedSet) {
            WeightedSet wset = (WeightedSet)fval;
            WeightedSetDataType wtype = wset.getDataType();
            Integer weight = wset.get(this.value);
            if (weight == null) {
                if (wtype.createIfNonExistent() && this.update instanceof ArithmeticValueUpdate) {
                    weight = 0;
                } else {
                    return fval;
                }
            }
            weight = (Integer)this.update.applyTo(new IntegerFieldValue(weight)).getWrappedValue();
            wset.put(this.value, weight);
            if (wtype.removeIfZero() && this.update instanceof ArithmeticValueUpdate && weight == 0) {
                wset.remove(this.value);
            }
        }
        return fval;
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (fieldType instanceof ArrayDataType) {
            if (!(this.value instanceof IntegerFieldValue)) {
                throw new IllegalArgumentException("Expected integer, got " + this.value.getClass().getName() + ".");
            }
            this.update.checkCompatibility(((ArrayDataType)fieldType).getNestedType());
        } else if (fieldType instanceof WeightedSetDataType) {
            ((WeightedSetDataType)fieldType).getNestedType().createFieldValue().assign(this.value);
            this.update.checkCompatibility(DataType.INT);
        } else if (fieldType instanceof StructuredDataType) {
            if (!(this.value instanceof StringFieldValue)) {
                throw new IllegalArgumentException("Expected string, got " + this.value.getClass().getName() + ".");
            }
            Field field = ((StructuredDataType)fieldType).getField(((StringFieldValue)this.value).getString());
            if (field == null) {
                throw new IllegalArgumentException("Field '" + String.valueOf(this.value) + "' not found.");
            }
            this.update.checkCompatibility(field.getDataType());
        } else {
            throw new UnsupportedOperationException("Field type " + fieldType.getName() + " not supported.");
        }
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this, superType);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MapValueUpdate && super.equals(o) && this.value.equals(((MapValueUpdate)o).value) && this.update.equals(((MapValueUpdate)o).update);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.value.hashCode() + this.update.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.value) + " " + String.valueOf(this.update);
    }
}

