/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.filedistribution.fileacquirer;

import com.yahoo.config.FileReference;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.filedistribution.fileacquirer.TimeoutException;
import com.yahoo.filedistribution.fileacquirer.Timer;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.net.HostName;
import java.io.File;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

class FileAcquirerImpl
implements FileAcquirer {
    private static final Logger log = Logger.getLogger(FileAcquirerImpl.class.getName());
    private final Supervisor supervisor = new Supervisor(new Transport("fileaquirer"));
    private final Connection connection = new Connection();

    FileAcquirerImpl() {
    }

    private boolean temporaryError(int errorCode) {
        return switch (errorCode) {
            case 100, 102, 103, 104, 108, 69632 -> true;
            default -> false;
        };
    }

    @Override
    public void shutdown() {
        this.supervisor.transport().shutdown().join();
    }

    @Override
    public File waitFor(FileReference fileReference, long timeout, TimeUnit timeUnit) throws InterruptedException {
        Target target;
        Timer timer = new Timer(timeout, timeUnit);
        while ((target = this.connection.getTarget(timer)) != null) {
            Request request = new Request("waitFor");
            request.parameters().add((Value)new StringValue(fileReference.value()));
            double rpcTimeout = Math.min((double)timer.timeLeft(TimeUnit.SECONDS), 60.0);
            log.log(Level.FINE, () -> "InvokeSync waitFor " + String.valueOf(fileReference) + " with " + rpcTimeout + " seconds timeout");
            target.invokeSync(request, rpcTimeout);
            if (request.checkReturnTypes("s")) {
                return new File(request.returnValues().get(0).asString());
            }
            if (!request.isError()) {
                throw new RuntimeException("Invalid response: " + String.valueOf(request.returnValues()));
            }
            if (!this.temporaryError(request.errorCode())) {
                throw new RuntimeException("Wait for " + String.valueOf(fileReference) + " failed: " + request.errorMessage() + " (" + request.errorCode() + ")");
            }
            log.log(Level.INFO, "Retrying waitFor for " + String.valueOf(fileReference) + ": " + request.errorCode() + " -- " + request.errorMessage());
            Thread.sleep(1000L);
            if (timer.isTimeLeft()) continue;
        }
        throw new TimeoutException("Timed out waiting for " + String.valueOf(fileReference) + " after " + timeout + " " + timeUnit.name().toLowerCase());
    }

    static final class FileDistributionErrorCode {
        public static final int baseErrorCode = 65536;
        public static final int baseFileProviderErrorCode = 69632;
        public static final int fileReferenceNotFound = 69632;

        FileDistributionErrorCode() {
        }
    }

    private class Connection {
        private static final int configProxyRpcPort = 19090;
        private final Lock targetLock = new ReentrantLock();
        private final Spec spec = new Spec(HostName.getLocalhost(), 19090);
        private long pauseTime = 0L;
        private Target target;
        private long nextLogTime = 0L;
        private long logCount = 0L;

        private Connection() {
        }

        private void connect(Timer timer) throws InterruptedException {
            while (timer.isTimeLeft()) {
                this.pause();
                this.target = FileAcquirerImpl.this.supervisor.connect(this.spec);
                Request request = new Request("frt.rpc.ping");
                this.target.invokeSync(request, Duration.ofSeconds(5L));
                if (request.isError()) {
                    this.logWarning();
                    this.target.close();
                    continue;
                }
                log.log(Level.FINE, () -> "Successfully connected to '" + String.valueOf(this.spec) + "', this = " + System.identityHashCode(this));
                this.pauseTime = 0L;
                this.logCount = 0L;
                return;
            }
        }

        private void pause() throws InterruptedException {
            if (this.pauseTime > 0L) {
                Thread.sleep(this.pauseTime);
                this.pauseTime = Math.min((long)((double)this.pauseTime * 1.5), TimeUnit.MINUTES.toMillis(1L));
            } else {
                this.pauseTime = 500L;
            }
        }

        private void logWarning() {
            if (this.logCount == 0L || System.currentTimeMillis() > this.nextLogTime) {
                log.warning("Could not connect to the config proxy '" + String.valueOf(this.spec) + "' - " + String.valueOf(this) + "@" + System.identityHashCode(this));
                this.nextLogTime = System.currentTimeMillis() + Math.min(TimeUnit.DAYS.toMillis(1L), TimeUnit.SECONDS.toMillis(30L) * ++this.logCount);
                log.info("Next log time = " + this.nextLogTime + ", current = " + System.currentTimeMillis());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Target getTarget(Timer timer) throws InterruptedException {
            TimeUnit unit = TimeUnit.MILLISECONDS;
            this.targetLock.tryLock(timer.timeLeft(unit), unit);
            try {
                if (this.target == null || !this.target.isValid()) {
                    this.connect(timer);
                }
                Target target = this.target;
                return target;
            }
            finally {
                this.targetLock.unlock();
            }
        }
    }
}

