/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.util.http.hc4;

import ai.vespa.util.http.AcceptAllHostnamesVerifier;
import com.yahoo.security.tls.TlsContext;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class SslConnectionSocketFactory {
    private SslConnectionSocketFactory() {
    }

    public static SSLConnectionSocketFactory of(SSLContext ctx, HostnameVerifier verifier) {
        return new SSLConnectionSocketFactory(ctx, SslConnectionSocketFactory.protocols(ctx), SslConnectionSocketFactory.cipherSuites(ctx), verifier);
    }

    public static SSLConnectionSocketFactory of(SSLContext ctx) {
        return SslConnectionSocketFactory.of(ctx, SslConnectionSocketFactory.defaultVerifier());
    }

    public static SSLConnectionSocketFactory of(TlsContext ctx, HostnameVerifier verifier) {
        return new SSLConnectionSocketFactory(ctx.sslContext().context(), ctx.parameters().getProtocols(), ctx.parameters().getCipherSuites(), verifier);
    }

    public static SSLConnectionSocketFactory of(SSLSocketFactory fac, HostnameVerifier verifier) {
        return new SSLConnectionSocketFactory(fac, SslConnectionSocketFactory.protocols(), SslConnectionSocketFactory.cipherSuites(), verifier);
    }

    public static SSLConnectionSocketFactory of() {
        return new SSLConnectionSocketFactory(TlsContext.defaultSslContext(), SslConnectionSocketFactory.protocols(), SslConnectionSocketFactory.cipherSuites(), SslConnectionSocketFactory.defaultVerifier());
    }

    public static SSLConnectionSocketFactory of(TlsContext ctx) {
        return SslConnectionSocketFactory.of(ctx, SslConnectionSocketFactory.defaultVerifier());
    }

    public static HostnameVerifier defaultVerifier() {
        return SSLConnectionSocketFactory.getDefaultHostnameVerifier();
    }

    public static HostnameVerifier noopVerifier() {
        return AcceptAllHostnamesVerifier.instance();
    }

    private static String[] cipherSuites(SSLContext ctx) {
        return SslConnectionSocketFactory.array(TlsContext.getAllowedCipherSuites((SSLContext)ctx));
    }

    private static String[] protocols(SSLContext ctx) {
        return SslConnectionSocketFactory.array(TlsContext.getAllowedProtocols((SSLContext)ctx));
    }

    private static String[] cipherSuites() {
        return SslConnectionSocketFactory.array(TlsContext.getAllowedCipherSuites());
    }

    private static String[] protocols() {
        return SslConnectionSocketFactory.array(TlsContext.getAllowedProtocols());
    }

    private static String[] array(Collection<String> c) {
        return (String[])c.toArray(String[]::new);
    }
}

