/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class FieldValueConverter {
    public final FieldValue convert(FieldValue value) {
        if (value == null) {
            return null;
        }
        if (this.shouldConvert(value)) {
            return this.doConvert(value);
        }
        if (value instanceof Array) {
            Array arrayValue = (Array)value;
            return this.convertArray(arrayValue);
        }
        if (value instanceof MapFieldValue) {
            MapFieldValue mapValue = (MapFieldValue)value;
            return this.convertMap((MapFieldValue<FieldValue, FieldValue>)mapValue);
        }
        if (value instanceof WeightedSet) {
            WeightedSet weightedSetValue = (WeightedSet)value;
            return this.convertWset(weightedSetValue);
        }
        if (value instanceof StructuredFieldValue) {
            StructuredFieldValue structuredFieldValue = (StructuredFieldValue)value;
            return this.convertStructured(structuredFieldValue);
        }
        return value;
    }

    private FieldValue convertArray(Array val) {
        LinkedList<FieldValue> next = new LinkedList<FieldValue>();
        DataType type = null;
        Iterator i = val.fieldValueIterator();
        while (i.hasNext()) {
            FieldValue value = this.convert((FieldValue)i.next());
            if (value == null) continue;
            if (type == null) {
                type = value.getDataType();
            } else if (!type.isValueCompatible(value)) {
                throw new IllegalArgumentException("Expected " + type.getName() + ", got " + value.getDataType().getName());
            }
            next.add(value);
        }
        if (type == null) {
            return null;
        }
        Array convertedValue = DataType.getArray(type).createFieldValue();
        convertedValue.addAll(next);
        return convertedValue;
    }

    protected FieldValue convertMap(MapFieldValue<FieldValue, FieldValue> val) {
        LinkedHashMap<FieldValue, FieldValue> convertedMap = new LinkedHashMap<FieldValue, FieldValue>();
        DataType keyType = null;
        DataType valueType = null;
        for (Map.Entry entry : val.entrySet()) {
            FieldValue value;
            FieldValue key = this.convert((FieldValue)entry.getKey());
            if (key == null) continue;
            if (keyType == null) {
                keyType = key.getDataType();
            } else if (!keyType.isValueCompatible(key)) {
                throw new IllegalArgumentException("Expected " + keyType.getName() + ", got " + key.getDataType().getName());
            }
            if ((value = this.convert((FieldValue)entry.getValue())) == null) continue;
            if (valueType == null) {
                valueType = value.getDataType();
            } else if (!valueType.isValueCompatible(value)) {
                throw new IllegalArgumentException("Expected " + valueType.getName() + ", got " + value.getDataType().getName());
            }
            convertedMap.put(key, value);
        }
        if (keyType == null || valueType == null) {
            return null;
        }
        MapFieldValue convertedValue = DataType.getMap(keyType, valueType).createFieldValue();
        convertedValue.putAll(convertedMap);
        return convertedValue;
    }

    private FieldValue convertWset(WeightedSet val) {
        LinkedHashMap<FieldValue, Integer> next = new LinkedHashMap<FieldValue, Integer>();
        DataType nextType = null;
        Iterator it = val.fieldValueIterator();
        while (it.hasNext()) {
            FieldValue prevKey = (FieldValue)it.next();
            Integer prevVal = val.get((Object)prevKey);
            FieldValue nextKey = this.convert(prevKey);
            if (nextKey == null) continue;
            if (nextType == null) {
                nextType = nextKey.getDataType();
            } else if (!nextType.isValueCompatible(nextKey)) {
                throw new IllegalArgumentException("Expected " + nextType.getName() + ", got " + nextKey.getDataType().getName());
            }
            next.put(nextKey, prevVal);
        }
        if (nextType == null) {
            return null;
        }
        WeightedSet ret = DataType.getWeightedSet(nextType, (boolean)val.getDataType().createIfNonExistent(), (boolean)val.getDataType().removeIfZero()).createFieldValue();
        ret.putAll(next);
        return ret;
    }

    private FieldValue convertStructured(StructuredFieldValue val) {
        StructuredFieldValue ret = val.getDataType().createFieldValue();
        for (Map.Entry entry : val) {
            FieldValue prev = (FieldValue)entry.getValue();
            FieldValue next = this.convert(prev);
            if (next == null) continue;
            ret.setFieldValue((Field)entry.getKey(), next);
        }
        return ret;
    }

    protected abstract boolean shouldConvert(FieldValue var1);

    protected abstract FieldValue doConvert(FieldValue var1);
}

