/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.util.Objects;

public final class ConstantExpression
extends Expression {
    private final FieldValue value;

    public ConstantExpression(FieldValue value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public boolean requiresInput() {
        return false;
    }

    public FieldValue getValue() {
        return this.value;
    }

    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        super.setInputType(inputType, context);
        return this.value.getDataType();
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        if (outputType != null && !this.value.getDataType().isAssignableTo(outputType)) {
            throw new VerificationException(this, "Produces type " + this.value.getDataType().getName() + ", but type " + outputType.getName() + " is required");
        }
        super.setOutputType(outputType, context);
        return AnyDataType.instance;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setCurrentValue(this.value);
    }

    public String toString() {
        if (this.value instanceof StringFieldValue) {
            return "\"" + StringUtilities.escape((String)this.value.toString(), (char)'\"') + "\"";
        }
        if (this.value instanceof LongFieldValue) {
            return String.valueOf(this.value) + "L";
        }
        return this.value.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstantExpression)) {
            return false;
        }
        ConstantExpression rhs = (ConstantExpression)((Object)obj);
        return this.value.equals((Object)rhs.value);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.value.hashCode();
    }
}

