/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;

public final class HexEncodeExpression
extends Expression {
    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        super.setInputType(inputType, (DataType)DataType.LONG, context);
        return DataType.STRING;
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        super.setOutputType((DataType)DataType.STRING, outputType, null, context);
        return DataType.LONG;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        long input = ((LongFieldValue)context.getCurrentValue()).getLong();
        context.setCurrentValue((FieldValue)new StringFieldValue(Long.toHexString(input)));
    }

    public String toString() {
        return "hexencode";
    }

    public boolean equals(Object obj) {
        return obj instanceof HexEncodeExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

