/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public abstract class Components<TYPE> {
    private final Function<String, TYPE> failingComponentFactory;

    Components(Function<String, TYPE> failingComponentFactory) {
        this.failingComponentFactory = failingComponentFactory;
    }

    public abstract Set<String> ids();

    public abstract boolean isEmpty();

    public abstract Optional<TYPE> singleSelected();

    public abstract boolean contains(String var1);

    public abstract TYPE get(String var1);

    public TYPE failingComponent(String message) {
        return this.failingComponentFactory.apply(message);
    }

    public static class Selected<TYPE> {
        private final String id;
        private final TYPE component;
        private final List<String> arguments;

        public Selected(String name, Components<TYPE> components, String selectedId, boolean noIdIsAllowed, List<String> arguments) {
            boolean selectedIdProvided;
            this.id = selectedId;
            this.arguments = List.copyOf(arguments);
            boolean bl = selectedIdProvided = selectedId != null && !selectedId.isEmpty();
            if (components.isEmpty()) {
                throw new IllegalStateException("No " + name + "s provided");
            }
            if (!selectedIdProvided && !noIdIsAllowed) {
                throw new IllegalArgumentException("A " + name + " id must be specified. Valid " + name + "s are " + this.validComponents(components));
            }
            this.component = components.singleSelected().isPresent() && !selectedIdProvided ? components.singleSelected().get() : (!components.singleSelected().isPresent() && !selectedIdProvided ? components.failingComponent("Multiple " + name + "s are provided but no " + name + " id is given. Valid " + name + "s are " + this.validComponents(components)) : (!components.contains(selectedId) ? components.failingComponent("Can't find " + name + " '" + selectedId + "'. Valid " + name + "s are " + this.validComponents(components)) : components.get(selectedId)));
        }

        public String id() {
            return this.id;
        }

        public TYPE component() {
            return this.component;
        }

        public List<String> arguments() {
            return this.arguments;
        }

        public String argumentsString() {
            StringBuilder sb = new StringBuilder();
            if (this.id != null && !this.id.isEmpty()) {
                sb.append(" ").append(this.id);
            }
            this.arguments.forEach(arg -> sb.append(" ").append((String)arg));
            return sb.toString();
        }

        private String validComponents(Components<TYPE> components) {
            ArrayList<String> componentIds = new ArrayList<String>(components.ids());
            componentIds.sort(null);
            return String.join((CharSequence)", ", componentIds);
        }

        public String toString() {
            return "selected " + String.valueOf(this.component);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Selected)) {
                return false;
            }
            Selected other = (Selected)o;
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            return Objects.equals(this.arguments, other.arguments);
        }

        public int hashCode() {
            return Objects.hash(Selected.class, this.id, this.arguments);
        }
    }

    public static class Ignored<TYPE>
    extends Components<TYPE> {
        public Ignored(Function<String, TYPE> failingComponentFactory) {
            super(failingComponentFactory);
        }

        @Override
        public Set<String> ids() {
            return Set.of();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Optional<TYPE> singleSelected() {
            return Optional.of(this.failingComponent("Components can not be created in this environment"));
        }

        @Override
        public boolean contains(String componentId) {
            return true;
        }

        @Override
        public TYPE get(String componentId) {
            return this.failingComponent("Components can not be created in this environment");
        }
    }

    public static class Map<TYPE>
    extends Components<TYPE> {
        private final java.util.Map<String, TYPE> components;

        public Map(java.util.Map<String, TYPE> components, Function<String, TYPE> failingComponentFactory) {
            super(failingComponentFactory);
            this.components = components;
        }

        @Override
        public Set<String> ids() {
            return this.components.keySet();
        }

        @Override
        public boolean isEmpty() {
            return this.components.isEmpty();
        }

        @Override
        public Optional<TYPE> singleSelected() {
            if (this.components.size() != 1) {
                return Optional.empty();
            }
            return this.components.values().stream().findFirst();
        }

        @Override
        public boolean contains(String componentId) {
            return this.components.containsKey(componentId);
        }

        @Override
        public TYPE get(String componentId) {
            return this.components.get(componentId);
        }
    }
}

