/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Packet;
import com.yahoo.jrt.Values;
import java.nio.ByteBuffer;

class ReplyPacket
extends Packet {
    private Values returnValues;

    public ReplyPacket(int flags, int reqId, Values returnValues) {
        super(flags, reqId);
        this.returnValues = returnValues;
    }

    public ReplyPacket(int flags, int reqId, ByteBuffer src) {
        super(flags, reqId);
        this.returnValues = new Values(src);
    }

    @Override
    public int bytes() {
        return 12 + this.returnValues.bytes();
    }

    @Override
    public int packetCode() {
        return 101;
    }

    @Override
    public void encode(ByteBuffer dst) {
        this.returnValues.encode(dst);
    }

    public Values returnValues() {
        return this.returnValues;
    }
}

