/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestAccessFilter;
import com.yahoo.security.tls.Capability;
import com.yahoo.security.tls.CapabilitySet;
import com.yahoo.security.tls.MissingCapabilitiesException;

public class RequireCapabilitiesFilter
implements RequestAccessFilter {
    private static final RequireCapabilitiesFilter UNCLASSIFIED = new RequireCapabilitiesFilter(Capability.RPC_UNCLASSIFIED);
    private final CapabilitySet requiredCapabilities;

    public RequireCapabilitiesFilter(CapabilitySet requiredCapabilities) {
        this.requiredCapabilities = requiredCapabilities;
    }

    public RequireCapabilitiesFilter(Capability ... requiredCapabilities) {
        this(CapabilitySet.of((Capability[])requiredCapabilities));
    }

    public static RequireCapabilitiesFilter unclassified() {
        return UNCLASSIFIED;
    }

    @Override
    public boolean allow(Request r) {
        try {
            r.target().connectionAuthContext().verifyCapabilities(this.requiredCapabilities, "RPC", r.methodName(), r.target().peerSpec().toString());
            return true;
        }
        catch (MissingCapabilitiesException e) {
            return false;
        }
    }
}

