/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.language.Language;
import com.yahoo.language.process.StemList;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Stemmer;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.Tokenizer;
import java.util.ArrayList;
import java.util.List;

public class StemmerImpl
implements Stemmer {
    private final Tokenizer tokenizer;

    public StemmerImpl(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public List<StemList> stem(String input, StemMode stemMode, Language language) {
        ArrayList<StemList> stems = new ArrayList<StemList>();
        for (Token token : this.tokenizer.tokenize(input, language, stemMode, false)) {
            this.findStems(token, stems);
        }
        return stems;
    }

    private void findStems(Token token, List<StemList> out) {
        int len;
        if (token.isSpecialToken() || (len = token.getNumComponents()) == 0) {
            if (token.isIndexable()) {
                StemList word = new StemList();
                word.add(token.getTokenString());
                for (int i = 1; i < token.getNumStems(); ++i) {
                    word.add(token.getStem(i));
                }
                out.add(word);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.findStems(token.getComponent(i), out);
            }
        }
    }
}

