/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.simple;

import com.yahoo.language.Language;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.SpecialTokenRegistry;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.TokenType;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.process.Transformer;
import com.yahoo.language.simple.SimpleNormalizer;
import com.yahoo.language.simple.SimpleToken;
import com.yahoo.language.simple.SimpleTokenType;
import com.yahoo.language.simple.SimpleTransformer;
import com.yahoo.language.simple.kstem.KStemmer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleTokenizer
implements Tokenizer {
    private static final Logger log = Logger.getLogger(SimpleTokenizer.class.getName());
    private static final int SPACE_CODE = 32;
    private final Normalizer normalizer;
    private final Transformer transformer;
    private final KStemmer stemmer = new KStemmer();
    private final SpecialTokenRegistry specialTokenRegistry;

    public SimpleTokenizer() {
        this(new SimpleNormalizer(), new SimpleTransformer());
    }

    public SimpleTokenizer(Normalizer normalizer) {
        this(normalizer, new SimpleTransformer());
    }

    public SimpleTokenizer(Normalizer normalizer, Transformer transformer) {
        this(normalizer, transformer, new SpecialTokenRegistry(List.of()));
    }

    public SimpleTokenizer(Normalizer normalizer, Transformer transformer, SpecialTokenRegistry specialTokenRegistry) {
        this.normalizer = normalizer;
        this.transformer = transformer;
        this.specialTokenRegistry = specialTokenRegistry;
    }

    @Override
    public Iterable<Token> tokenize(String input, Language language, StemMode stemMode, boolean removeAccents) {
        return this.tokenize(input, token -> this.processToken((String)token, language, stemMode, removeAccents));
    }

    public Iterable<Token> tokenize(String input, Function<String, String> tokenProcessor) {
        TokenType prevType;
        if (input.isEmpty()) {
            return List.of();
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int nextCode = input.codePointAt(0);
        TokenType tokenType = prevType = SimpleTokenType.valueOf(nextCode);
        int prev = 0;
        for (int next = Character.charCount(nextCode); next <= input.length(); next += Character.charCount(nextCode)) {
            nextCode = next < input.length() ? input.codePointAt(next) : 32;
            TokenType nextType = SimpleTokenType.valueOf(nextCode);
            if (this.isAtTokenBoundary(prevType, nextType)) {
                String original = input.substring(prev, next);
                tokens.add(new SimpleToken(original).setOffset(prev).setType(tokenType).setTokenString(tokenProcessor.apply(original)));
                prev = next;
                tokenType = prevType = nextType;
                continue;
            }
            tokenType = this.determineType(tokenType, nextType);
        }
        return tokens;
    }

    private boolean isAtTokenBoundary(TokenType prevType, TokenType nextType) {
        if (prevType == TokenType.INDEXABLE_SYMBOL || nextType == TokenType.INDEXABLE_SYMBOL) {
            return true;
        }
        return !prevType.isIndexable() || !nextType.isIndexable();
    }

    private TokenType determineType(TokenType tokenType, TokenType characterType) {
        if (characterType == TokenType.ALPHABETIC) {
            return TokenType.ALPHABETIC;
        }
        return tokenType;
    }

    private String processToken(String token, Language language, StemMode stemMode, boolean removeAccents) {
        String original = token;
        log.log(Level.FINEST, () -> "processToken '" + original + "'");
        token = this.normalizer.normalize(token);
        token = LinguisticsCase.toLowerCase(token);
        if (removeAccents) {
            token = this.transformer.accentDrop(token, language);
        }
        if (stemMode != StemMode.NONE) {
            String oldToken = token;
            String newToken = token = this.stemmer.stem(token);
            log.log(Level.FINEST, () -> "stem '" + oldToken + "' to '" + newToken + "'");
        }
        String result = token;
        log.log(Level.FINEST, () -> "processed token is: " + result);
        return result;
    }
}

